/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.CentralizedThreadLocal;
import java.lang.reflect.Method;

public class InitialThreadLocal<T>
extends CentralizedThreadLocal<T> {
    private static final String _METHOD_CLONE = "clone";
    private static final Log _log = LogFactoryUtil.getLog(InitialThreadLocal.class);
    private final Method _cloneMethod;
    private final T _initialValue;
    private final String _name;

    public InitialThreadLocal(String name, T initialValue) {
        this(name, initialValue, false);
    }

    public InitialThreadLocal(String name, T initialValue, boolean shortLived) {
        super(shortLived);
        this._name = name;
        this._initialValue = initialValue;
        Method cloneMethod = null;
        if (this._initialValue instanceof Cloneable) {
            try {
                Class<?> clazz = this._initialValue.getClass();
                cloneMethod = clazz.getMethod(_METHOD_CLONE, new Class[0]);
            }
            catch (Exception e) {
                _log.error(e, e);
            }
        }
        this._cloneMethod = cloneMethod;
    }

    public String toString() {
        if (this._name != null) {
            return this._name;
        }
        return super.toString();
    }

    @Override
    protected T initialValue() {
        if (this._cloneMethod != null) {
            try {
                return (T)this._cloneMethod.invoke(this._initialValue, new Object[0]);
            }
            catch (Exception e) {
                _log.error(e, e);
            }
        }
        return this._initialValue;
    }
}

