/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.TreeModel;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.TreeModelTasks;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class TreePathUtil {
    private static final int _MODEL_TREE_REBUILD_QUERY_RESULTS_BATCH_SIZE = GetterUtil.getInteger(PropsUtil.get("model.tree.rebuild.query.results.batch.size"));

    public static void rebuildTree(long companyId, long parentPrimaryKey, String parentTreePath, TreeModelTasks<?> treeModelTasks) throws PortalException {
        ArrayList<TreeModel> modifiedTreeModels = new ArrayList<TreeModel>();
        LinkedList<Object[]> traces = new LinkedList<Object[]>();
        traces.push(new Object[]{parentPrimaryKey, parentTreePath, 0L});
        Object[] trace = null;
        while ((trace = (Object[])traces.poll()) != null) {
            Long curParentPrimaryKey = (Long)trace[0];
            String curParentTreePath = (String)trace[1];
            Long previousPrimaryKey = (Long)trace[2];
            treeModelTasks.rebuildDependentModelsTreePaths(curParentPrimaryKey, curParentTreePath);
            List<?> treeModels = treeModelTasks.findTreeModels(previousPrimaryKey, companyId, curParentPrimaryKey, _MODEL_TREE_REBUILD_QUERY_RESULTS_BATCH_SIZE);
            if (treeModels.isEmpty()) continue;
            if (treeModels.size() == _MODEL_TREE_REBUILD_QUERY_RESULTS_BATCH_SIZE) {
                TreeModel treeModel = (TreeModel)treeModels.get(treeModels.size() - 1);
                trace[2] = treeModel.getPrimaryKeyObj();
                traces.push(trace);
            }
            for (TreeModel treeModel : treeModels) {
                String treePath = curParentTreePath.concat(String.valueOf(treeModel.getPrimaryKeyObj())).concat("/");
                treeModel.updateTreePath(treePath);
                traces.push(new Object[]{treeModel.getPrimaryKeyObj(), treePath, 0L});
                modifiedTreeModels.add(treeModel);
            }
        }
        treeModelTasks.reindexTreeModels(modifiedTreeModels);
    }
}

