/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cache;

import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.SkipReplicationThreadLocal;
import java.io.Serializable;

public class PortalCacheHelperUtil {
    public static <K extends Serializable, V> void putWithoutReplicator(PortalCache<K, V> portalCache, K key, V value) {
        PortalCacheHelperUtil.putWithoutReplicator(portalCache, key, value, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K extends Serializable, V> void putWithoutReplicator(PortalCache<K, V> portalCache, K key, V value, int timeToLive) {
        boolean enabled = SkipReplicationThreadLocal.isEnabled();
        if (!enabled) {
            SkipReplicationThreadLocal.setEnabled(true);
        }
        try {
            portalCache.put(key, value, timeToLive);
        }
        finally {
            if (!enabled) {
                SkipReplicationThreadLocal.setEnabled(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAllWithoutReplicator(PortalCache<?, ?> portalCache) {
        boolean skip = SkipReplicationThreadLocal.isEnabled();
        if (!skip) {
            SkipReplicationThreadLocal.setEnabled(true);
        }
        try {
            portalCache.removeAll();
        }
        finally {
            if (!skip) {
                SkipReplicationThreadLocal.setEnabled(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K extends Serializable> void removeWithoutReplicator(PortalCache<K, ?> portalCache, K key) {
        boolean skip = SkipReplicationThreadLocal.isEnabled();
        if (!skip) {
            SkipReplicationThreadLocal.setEnabled(true);
        }
        try {
            portalCache.remove(key);
        }
        finally {
            if (!skip) {
                SkipReplicationThreadLocal.setEnabled(false);
            }
        }
    }
}

