/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cluster;

import com.liferay.portal.kernel.cluster.ClusterNodeResponse;
import com.liferay.portal.kernel.cluster.ClusterNodeResponses;
import com.liferay.portal.kernel.concurrent.DefaultNoticeableFuture;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class FutureClusterResponses
extends DefaultNoticeableFuture<ClusterNodeResponses> {
    private final ClusterNodeResponses _clusterNodeResponses;
    private final AtomicInteger _counter;

    public FutureClusterResponses(Set<String> clusterNodeIds) {
        this._clusterNodeResponses = new ClusterNodeResponses(clusterNodeIds);
        int size = clusterNodeIds.size();
        if (size == 0) {
            this.set(this._clusterNodeResponses);
        }
        this._counter = new AtomicInteger(size);
    }

    public boolean addClusterNodeResponse(ClusterNodeResponse clusterNodeResponse) {
        if (this._clusterNodeResponses.addClusterResponse(clusterNodeResponse)) {
            if (this._counter.decrementAndGet() == 0) {
                this.set(this._clusterNodeResponses);
            }
            return true;
        }
        return false;
    }

    @Override
    public ClusterNodeResponses get() throws InterruptedException {
        try {
            return (ClusterNodeResponses)super.get();
        }
        catch (ExecutionException ee) {
            throw new AssertionError((Object)ee);
        }
    }

    @Override
    public ClusterNodeResponses get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        try {
            return (ClusterNodeResponses)super.get(timeout, unit);
        }
        catch (ExecutionException ee) {
            throw new AssertionError((Object)ee);
        }
    }

    public BlockingQueue<ClusterNodeResponse> getPartialResults() {
        return this._clusterNodeResponses.getClusterResponses();
    }
}

