/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.deploy.auto;

import com.liferay.portal.kernel.deploy.auto.AutoDeployException;
import com.liferay.portal.kernel.deploy.auto.AutoDeployListener;
import com.liferay.portal.kernel.deploy.auto.AutoDeployer;
import com.liferay.portal.kernel.deploy.auto.context.AutoDeploymentContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.File;

public abstract class BaseAutoDeployListener
implements AutoDeployListener {
    private static final Log _log = LogFactoryUtil.getLog(BaseAutoDeployListener.class);

    @Override
    public final int deploy(AutoDeploymentContext autoDeploymentContext) throws AutoDeployException {
        AutoDeployer autoDeployer;
        int code;
        File file = autoDeploymentContext.getFile();
        if (_log.isDebugEnabled()) {
            _log.debug("Invoking deploy for " + file.getPath());
        }
        if (_log.isInfoEnabled()) {
            _log.info(this.getPluginPathInfoMessage(file));
        }
        if ((code = (autoDeployer = this.buildAutoDeployer()).autoDeploy(autoDeploymentContext)) == 1 && _log.isInfoEnabled()) {
            _log.info(this.getSuccessMessage(file));
        }
        return code;
    }

    @Override
    public boolean isDeployable(AutoDeploymentContext autoDeploymentContext) throws AutoDeployException {
        return this.isDeployable(autoDeploymentContext.getFile());
    }

    protected abstract AutoDeployer buildAutoDeployer() throws AutoDeployException;

    protected abstract String getPluginPathInfoMessage(File var1);

    protected abstract String getSuccessMessage(File var1);

    protected abstract boolean isDeployable(File var1) throws AutoDeployException;
}

