/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.xml;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.util.xml.DocUtil;
import java.lang.reflect.Method;
import java.util.List;

public class BeanToXMLUtil {
    private static final Log _log = LogFactoryUtil.getLog(BeanToXMLUtil.class);

    public static void addBean(Object obj, Element parentEl) {
        Class<?> clazz = obj.getClass();
        String classNameWithoutPackage = BeanToXMLUtil.getClassNameWithoutPackage(clazz.getName());
        Element el = parentEl.addElement(classNameWithoutPackage);
        BeanToXMLUtil.addFields(obj, el);
    }

    public static void addFields(Object obj, Element parentEl) {
        Class<?> clazz = obj.getClass();
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().startsWith("get") || method.getName().equals("getClass")) continue;
            String memberName = StringUtil.replace((String)method.getName(), (String)"get", (String)"");
            memberName = TextFormatter.format((String)memberName, (int)8);
            memberName = TextFormatter.format((String)memberName, (int)10);
            try {
                Object returnValue = method.invoke(obj, new Object[0]);
                if (returnValue instanceof List) {
                    List list = (List)returnValue;
                    Element listEl = parentEl.addElement(memberName);
                    for (int j = 0; j < list.size(); ++j) {
                        BeanToXMLUtil.addBean(list.get(j), listEl);
                    }
                    continue;
                }
                DocUtil.add(parentEl, memberName, returnValue.toString());
                continue;
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)e.getMessage());
            }
        }
    }

    public static String getClassNameWithoutPackage(String className) {
        String[] classNameArray = StringUtil.split((String)className, (char)'.');
        String classNameWithoutPackage = classNameArray[classNameArray.length - 1];
        classNameWithoutPackage = TextFormatter.format((String)classNameWithoutPackage, (int)8);
        classNameWithoutPackage = TextFormatter.format((String)classNameWithoutPackage, (int)10);
        return classNameWithoutPackage;
    }
}

