/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.messaging;

import com.liferay.mail.util.HookFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.mail.MailMessage;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.security.auth.EmailAddressGenerator;
import com.liferay.portal.security.auth.EmailAddressGeneratorFactory;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.mail.MailEngine;
import java.util.ArrayList;
import javax.mail.internet.InternetAddress;

public class MailMessageListener
extends BaseMessageListener {
    private static Log _log = LogFactoryUtil.getLog(MailMessageListener.class);

    protected void doMailMessage(MailMessage mailMessage) throws Exception {
        InternetAddress from;
        Object[] auditTrail = InternetAddress.parse((String)PropsValues.MAIL_AUDIT_TRAIL);
        if (auditTrail.length > 0) {
            Object[] bcc = mailMessage.getBCC();
            if (bcc != null) {
                Object[] allBCC = new InternetAddress[bcc.length + auditTrail.length];
                ArrayUtil.combine((Object[])bcc, (Object[])auditTrail, (Object[])allBCC);
                mailMessage.setBCC((InternetAddress[])allBCC);
            } else {
                mailMessage.setBCC((InternetAddress[])auditTrail);
            }
        }
        if ((from = this.filterInternetAddress(mailMessage.getFrom())) == null) {
            return;
        }
        mailMessage.setFrom(from);
        InternetAddress[] to = this.filterInternetAddresses(mailMessage.getTo());
        mailMessage.setTo(to);
        InternetAddress[] cc = this.filterInternetAddresses(mailMessage.getCC());
        mailMessage.setCC(cc);
        InternetAddress[] bcc = this.filterInternetAddresses(mailMessage.getBCC());
        mailMessage.setBCC(bcc);
        InternetAddress[] bulkAddresses = this.filterInternetAddresses(mailMessage.getBulkAddresses());
        mailMessage.setBulkAddresses(bulkAddresses);
        if (to != null && to.length > 0 || cc != null && cc.length > 0 || bcc != null && bcc.length > 0 || bulkAddresses != null && bulkAddresses.length > 0) {
            MailEngine.send((MailMessage)mailMessage);
        }
    }

    protected void doMethodHandler(MethodHandler methodHandler) throws Exception {
        methodHandler.invoke((Object)HookFactory.getInstance());
    }

    protected void doReceive(Message message) throws Exception {
        Object payload = message.getPayload();
        if (payload instanceof MailMessage) {
            this.doMailMessage((MailMessage)payload);
        } else if (payload instanceof MethodHandler) {
            this.doMethodHandler((MethodHandler)payload);
        }
    }

    protected InternetAddress filterInternetAddress(InternetAddress internetAddress) {
        EmailAddressGenerator emailAddressGenerator = EmailAddressGeneratorFactory.getInstance();
        if (emailAddressGenerator.isFake(internetAddress.getAddress())) {
            return null;
        }
        String address = internetAddress.toString();
        char[] cArray = address.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c2 = cArray[n2];
            if (c2 == '\n' || c2 == '\r') {
                if (_log.isWarnEnabled()) {
                    StringBundler sb = new StringBundler(4);
                    sb.append("Email address ");
                    sb.append(address);
                    sb.append(" contains line break characters and will be ");
                    sb.append("excluded from the email");
                    _log.warn((Object)sb.toString());
                }
                return null;
            }
            ++n2;
        }
        return internetAddress;
    }

    protected InternetAddress[] filterInternetAddresses(InternetAddress[] internetAddresses) {
        if (internetAddresses == null) {
            return null;
        }
        ArrayList<InternetAddress> filteredInternetAddresses = new ArrayList<InternetAddress>(internetAddresses.length);
        InternetAddress[] internetAddressArray = internetAddresses;
        int n = internetAddresses.length;
        int n2 = 0;
        while (n2 < n) {
            InternetAddress internetAddress = internetAddressArray[n2];
            InternetAddress filteredInternetAddress = this.filterInternetAddress(internetAddress);
            if (filteredInternetAddress != null) {
                filteredInternetAddresses.add(filteredInternetAddress);
            }
            ++n2;
        }
        return filteredInternetAddresses.toArray(new InternetAddress[filteredInternetAddresses.size()]);
    }
}

