/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.UserLockoutException;
import com.liferay.portal.UserPasswordException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Ticket;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.AuthTokenUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.pwd.PwdToolkitUtilThreadLocal;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.TicketLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletURLImpl;
import com.liferay.portlet.login.util.LoginUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class UpdatePasswordAction
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        Ticket ticket = this.getTicket(request);
        if (!themeDisplay.isSignedIn() && ticket == null) {
            return mapping.findForward("/common/referer_jsp.jsp");
        }
        String cmd = ParamUtil.getString((HttpServletRequest)request, (String)"cmd");
        if (Validator.isNull((String)cmd)) {
            if (ticket != null) {
                User user = UserLocalServiceUtil.getUser((long)ticket.getClassPK());
                try {
                    UserLocalServiceUtil.checkLockout((User)user);
                    UserLocalServiceUtil.updatePasswordReset((long)user.getUserId(), (boolean)true);
                }
                catch (UserLockoutException ule) {
                    SessionErrors.add((HttpServletRequest)request, ((Object)((Object)ule)).getClass());
                }
            }
            return mapping.findForward("portal.update_password");
        }
        try {
            this.updatePassword(request, response, themeDisplay, ticket);
            PortletURLImpl portletURL = new PortletURLImpl(request, "58", themeDisplay.getPlid(), "RENDER_PHASE");
            response.sendRedirect(portletURL.toString());
            return null;
        }
        catch (Exception e2) {
            if (e2 instanceof UserPasswordException) {
                SessionErrors.add((HttpServletRequest)request, e2.getClass(), (Object)e2);
                return mapping.findForward("portal.update_password");
            }
            if (e2 instanceof NoSuchUserException || e2 instanceof PrincipalException) {
                SessionErrors.add((HttpServletRequest)request, e2.getClass());
                return mapping.findForward("portal.error");
            }
            PortalUtil.sendError((Exception)e2, (HttpServletRequest)request, (HttpServletResponse)response);
            return null;
        }
    }

    protected Ticket getTicket(HttpServletRequest request) {
        Ticket ticket;
        block5: {
            String ticketKey = ParamUtil.getString((HttpServletRequest)request, (String)"ticketKey");
            if (Validator.isNull((String)ticketKey)) {
                return null;
            }
            try {
                ticket = TicketLocalServiceUtil.getTicket((String)ticketKey);
                if (ticket.getType() == 3) break block5;
                return null;
            }
            catch (Exception exception) {}
        }
        if (!ticket.isExpired()) {
            return ticket;
        }
        TicketLocalServiceUtil.deleteTicket((Ticket)ticket);
        return null;
    }

    protected boolean isValidatePassword(HttpServletRequest request) {
        HttpSession session = request.getSession();
        Boolean setupWizardPasswordUpdated = (Boolean)session.getAttribute("SETUP_WIZARD_PASSWORD_UPDATED");
        return setupWizardPasswordUpdated == null || setupWizardPasswordUpdated == false;
    }

    protected void updatePassword(HttpServletRequest request, HttpServletResponse response, ThemeDisplay themeDisplay, Ticket ticket) throws Exception {
        AuthTokenUtil.check((HttpServletRequest)request);
        long userId = 0L;
        userId = ticket != null ? ticket.getClassPK() : themeDisplay.getUserId();
        String password1 = request.getParameter("password1");
        String password2 = request.getParameter("password2");
        boolean passwordReset = false;
        boolean previousValidate = PwdToolkitUtilThreadLocal.isValidate();
        try {
            boolean currentValidate = this.isValidatePassword(request);
            PwdToolkitUtilThreadLocal.setValidate(currentValidate);
            UserLocalServiceUtil.updatePassword((long)userId, (String)password1, (String)password2, (boolean)passwordReset);
        }
        finally {
            PwdToolkitUtilThreadLocal.setValidate(previousValidate);
        }
        if (ticket != null) {
            TicketLocalServiceUtil.deleteTicket((Ticket)ticket);
            User user = UserLocalServiceUtil.getUser((long)userId);
            Company company = CompanyLocalServiceUtil.getCompanyById((long)user.getCompanyId());
            String login = null;
            String authType = company.getAuthType();
            if (authType.equals("emailAddress")) {
                login = user.getEmailAddress();
            } else if (authType.equals("screenName")) {
                login = user.getScreenName();
            } else if (authType.equals("userId")) {
                login = String.valueOf(userId);
            }
            LoginUtil.login(request, response, login, password1, false, null);
        } else if (PropsValues.SESSION_STORE_PASSWORD) {
            HttpSession session = request.getSession();
            session.setAttribute("USER_PASSWORD", (Object)password1);
        }
    }
}

