/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.asset;

import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portlet.asset.AssetRendererFactoryRegistry;
import com.liferay.portlet.asset.model.AssetRendererFactory;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetRendererFactoryRegistryImpl
implements AssetRendererFactoryRegistry {
    private Map<String, AssetRendererFactory> _assetRenderFactoriesMapByClassName = new ConcurrentHashMap<String, AssetRendererFactory>();
    private Map<String, AssetRendererFactory> _assetRenderFactoriesMapByClassType = new ConcurrentHashMap<String, AssetRendererFactory>();

    public List<AssetRendererFactory> getAssetRendererFactories() {
        return ListUtil.fromMapValues(this._assetRenderFactoriesMapByClassName);
    }

    public AssetRendererFactory getAssetRendererFactoryByClassName(String className) {
        return this._assetRenderFactoriesMapByClassName.get(className);
    }

    public AssetRendererFactory getAssetRendererFactoryByType(String type) {
        return this._assetRenderFactoriesMapByClassType.get(type);
    }

    public long[] getClassNameIds() {
        long[] classNameIds = new long[this._assetRenderFactoriesMapByClassName.size()];
        int i2 = 0;
        for (AssetRendererFactory assetRendererFactory : this._assetRenderFactoriesMapByClassName.values()) {
            classNameIds[i2] = assetRendererFactory.getClassNameId();
            ++i2;
        }
        return classNameIds;
    }

    public void register(AssetRendererFactory assetRendererFactory) {
        this._assetRenderFactoriesMapByClassName.put(assetRendererFactory.getClassName(), assetRendererFactory);
        this._assetRenderFactoriesMapByClassType.put(assetRendererFactory.getType(), assetRendererFactory);
    }

    public void unregister(AssetRendererFactory assetRendererFactory) {
        this._assetRenderFactoriesMapByClassName.remove(assetRendererFactory.getClassName());
        this._assetRenderFactoriesMapByClassType.remove(assetRendererFactory.getType());
    }
}

