/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.atom;

import com.liferay.portal.atom.AtomCollectionAdapterWrapper;
import com.liferay.portal.atom.AtomTargetBuilder;
import com.liferay.portal.kernel.atom.AtomCollectionAdapter;
import java.util.Collection;
import org.apache.abdera.protocol.Resolver;
import org.apache.abdera.protocol.server.CollectionAdapter;
import org.apache.abdera.protocol.server.CollectionInfo;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.TargetType;
import org.apache.abdera.protocol.server.WorkspaceInfo;
import org.apache.abdera.protocol.server.impl.AbstractWorkspaceProvider;
import org.apache.abdera.protocol.server.impl.RegexTargetResolver;
import org.apache.abdera.protocol.server.impl.SimpleWorkspaceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomProvider
extends AbstractWorkspaceProvider {
    private static final String[] _BASES = new String[]{"/api/secure/atom", "/api/atom"};
    private SimpleWorkspaceInfo _workspace;

    public AtomProvider() {
        this._initWorkspace();
        this._initTargetResolver();
        this._initTargetBuilder();
    }

    public <E> void addCollection(AtomCollectionAdapter<E> atomCollectionAdapter) {
        this._workspace.addCollection(new AtomCollectionAdapterWrapper<E>(atomCollectionAdapter));
    }

    public CollectionAdapter getCollectionAdapter(RequestContext request) {
        String path = request.getTargetPath();
        int index = path.indexOf(63);
        if (index != -1) {
            path = path.substring(0, index);
        }
        String baseUri = request.getBaseUri().toString();
        for (WorkspaceInfo workspaceInfo : this.workspaces) {
            Collection collections = workspaceInfo.getCollections(request);
            for (CollectionInfo collectionInfo : collections) {
                String href = collectionInfo.getHref(request);
                if (href == null) continue;
                if (href.startsWith(baseUri)) {
                    href = href.substring(baseUri.length() - 1);
                }
                if ((index = href.indexOf(63)) != -1) {
                    href = href.substring(0, index);
                }
                if (!path.startsWith(href)) continue;
                return (CollectionAdapter)collectionInfo;
            }
        }
        return null;
    }

    private void _initTargetBuilder() {
        this.setTargetBuilder(new AtomTargetBuilder());
    }

    private void _initTargetResolver() {
        RegexTargetResolver targetResolver = new RegexTargetResolver();
        String[] stringArray = _BASES;
        int n = _BASES.length;
        int n2 = 0;
        while (n2 < n) {
            String base = stringArray[n2];
            targetResolver.setPattern(String.valueOf(base) + "?(\\?[^#]*)?", TargetType.TYPE_SERVICE);
            targetResolver.setPattern(String.valueOf(base) + "/([^/#?;]+)(\\?[^#]*)?", TargetType.TYPE_COLLECTION, new String[]{"collection"});
            targetResolver.setPattern(String.valueOf(base) + "/([^/#?]+)/([^/#?:]+)(\\?[^#]*)?", TargetType.TYPE_ENTRY, new String[]{"collection", "entry"});
            targetResolver.setPattern(String.valueOf(base) + "/([^/#?]+)/([^/#?]+):media(\\?[^#]*)?", TargetType.TYPE_MEDIA, new String[]{"collection", "media"});
            ++n2;
        }
        this.setTargetResolver((Resolver)targetResolver);
    }

    private void _initWorkspace() {
        this._workspace = new SimpleWorkspaceInfo();
        this._workspace.setTitle("Liferay Workspace");
        this.addWorkspace((WorkspaceInfo)this._workspace);
    }
}

