/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.atom;

import com.liferay.portal.atom.AtomPager;
import com.liferay.portal.kernel.atom.AtomRequestContext;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import javax.servlet.http.HttpServletRequest;
import org.apache.abdera.protocol.server.RequestContext;

public class AtomUtil {
    private static final String _PAGER = String.valueOf(AtomUtil.class.getName()) + ".pager";
    private static final String _USER = String.valueOf(AtomUtil.class.getName()) + ".user";

    public static String createCollectionLink(AtomRequestContext atomRequestContext, String collectionName) {
        return AtomUtil.createEntryLink(atomRequestContext, collectionName, null);
    }

    public static String createEntryLink(AtomRequestContext atomRequestContext, String collectionName, String entryName) {
        StringBundler sb = new StringBundler(5);
        String targetBasePath = atomRequestContext.getTargetBasePath();
        sb.append(targetBasePath);
        sb.append('/');
        sb.append(collectionName);
        if (entryName != null) {
            sb.append('/');
            sb.append(entryName);
        }
        String entryLink = sb.toString();
        String resolvedUri = atomRequestContext.getResolvedUri();
        int pos = resolvedUri.indexOf(targetBasePath);
        if (pos != -1) {
            entryLink = String.valueOf(resolvedUri.substring(0, pos)) + entryLink;
        }
        return entryLink;
    }

    public static String createFeedTitleFromPortletName(AtomRequestContext atomRequestContext, String portletId) {
        String portletTitle = null;
        try {
            Company company = AtomUtil.getCompany();
            portletTitle = company.getName();
        }
        catch (Exception exception) {
            return null;
        }
        User user = AtomUtil.getUser(atomRequestContext);
        portletTitle = portletTitle.concat(" ");
        portletTitle = portletTitle.concat(PortalUtil.getPortletTitle((String)portletId, (User)user));
        portletTitle = portletTitle.trim();
        return portletTitle;
    }

    public static String createIdTagPrefix(String title) {
        Company company = null;
        try {
            company = AtomUtil.getCompany();
        }
        catch (Exception exception) {
            return "";
        }
        StringBundler sb = new StringBundler(5);
        sb.append("tag:");
        sb.append(company.getWebId());
        sb.append(":");
        sb.append(title);
        sb.append(":");
        String idTagPrefix = sb.toString();
        return idTagPrefix.toLowerCase();
    }

    public static Company getCompany() throws PortalException, SystemException {
        long companyId = CompanyThreadLocal.getCompanyId();
        return CompanyLocalServiceUtil.getCompanyById((long)companyId);
    }

    public static AtomPager getPager(RequestContext requestContext) {
        return (AtomPager)requestContext.getAttribute(RequestContext.Scope.REQUEST, _PAGER);
    }

    public static User getUser(AtomRequestContext atomRequestContext) {
        return (User)atomRequestContext.getRequestAttribute(_USER);
    }

    public static String resolveCollectionUrl(String url, String collectionName) {
        String collection = String.valueOf('/') + collectionName + '/';
        int collectionIndex = url.indexOf(collection);
        if (collectionIndex == -1) {
            return url;
        }
        int questionIndex = url.indexOf(63, collectionIndex += collectionName.length() + 1);
        url = questionIndex != -1 ? String.valueOf(url.substring(0, collectionIndex)) + url.substring(questionIndex) : url.substring(0, collectionIndex);
        return url;
    }

    public static void saveAtomPagerInRequest(AtomRequestContext atomRequestContext, AtomPager atomPager) {
        atomRequestContext.setRequestAttribute(_PAGER, (Object)atomPager);
    }

    public static void saveUserInRequest(HttpServletRequest request, User user) {
        request.setAttribute(_USER, (Object)user);
    }

    public static String setPageInUrl(String url, int page) {
        int pageIndex = url.indexOf("page=");
        if (pageIndex == -1) {
            int questionIndex = url.indexOf(63);
            url = questionIndex == -1 ? String.valueOf(url) + '?' : String.valueOf(url) + '&';
            return String.valueOf(url) + "page=" + page;
        }
        int endIndex = url.indexOf(38, pageIndex);
        if (endIndex == -1) {
            url = url.substring(0, pageIndex);
        } else {
            url = String.valueOf(url.substring(0, pageIndex)) + url.substring(endIndex + 1);
            url = String.valueOf(url) + '&';
        }
        url = String.valueOf(url) + "page=" + page;
        return url;
    }
}

