/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.bean;

import com.liferay.portal.bean.VelocityBeanHandler;
import com.liferay.portal.kernel.bean.BeanLocator;
import com.liferay.portal.kernel.bean.BeanLocatorException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.security.pacl.PACLBeanHandler;
import com.liferay.portal.service.persistence.BasePersistence;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanLocatorImpl
implements BeanLocator {
    public static final String VELOCITY_SUFFIX = ".velocity";
    private static Log _log = LogFactoryUtil.getLog(BeanLocatorImpl.class);
    private ApplicationContext _applicationContext;
    private ClassLoader _classLoader;
    private Map<String, Object> _paclPersistenceBeans = new ConcurrentHashMap<String, Object>();
    private String _paclServletContextName;
    private boolean _paclWrapPersistence;
    private Map<String, Object> _velocityBeans = new ConcurrentHashMap<String, Object>();

    public BeanLocatorImpl(ClassLoader classLoader, ApplicationContext applicationContext) {
        this._classLoader = classLoader;
        this._applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this._applicationContext;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public String[] getNames() {
        return this._applicationContext.getBeanDefinitionNames();
    }

    public Class<?> getType(String name) {
        try {
            return this._applicationContext.getType(name);
        }
        catch (Exception e2) {
            throw new BeanLocatorException((Throwable)e2);
        }
    }

    public <T> Map<String, T> locate(Class<T> clazz) {
        try {
            return this._applicationContext.getBeansOfType(clazz);
        }
        catch (Exception e2) {
            throw new BeanLocatorException((Throwable)e2);
        }
    }

    public Object locate(String name) throws BeanLocatorException {
        try {
            return this.doLocate(name);
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e2) {
            throw new BeanLocatorException((Throwable)e2);
        }
    }

    public void setPACLServletContextName(String paclServletContextName) {
        this._paclServletContextName = paclServletContextName;
    }

    public void setPACLWrapPersistence(boolean paclWrapPersistence) {
        this._paclWrapPersistence = paclWrapPersistence;
    }

    protected Object doLocate(String name) throws Exception {
        SecurityManager securityManager;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Locating " + name));
        }
        if (name.equals("portletClassLoader") && (securityManager = System.getSecurityManager()) != null) {
            RuntimePermission permission = new RuntimePermission("getClassLoader".concat(".").concat(this._paclServletContextName));
            securityManager.checkPermission(permission);
        }
        if (name.endsWith(VELOCITY_SUFFIX)) {
            Object velocityBean = this._velocityBeans.get(name);
            if (velocityBean == null) {
                String originalName = name.substring(0, name.length() - VELOCITY_SUFFIX.length());
                Object bean = this._applicationContext.getBean(originalName);
                velocityBean = ProxyUtil.newProxyInstance((ClassLoader)this._classLoader, (Class[])this.getInterfaces(bean), (InvocationHandler)new VelocityBeanHandler(bean, this._classLoader));
                this._velocityBeans.put(name, velocityBean);
            }
            return velocityBean;
        }
        Object bean = this._applicationContext.getBean(name);
        if (this._paclWrapPersistence && bean != null && bean instanceof BasePersistence) {
            Object paclPersistenceBean = this._paclPersistenceBeans.get(name);
            if (paclPersistenceBean != null) {
                return paclPersistenceBean;
            }
            paclPersistenceBean = ProxyUtil.newProxyInstance((ClassLoader)this._classLoader, (Class[])this.getInterfaces(bean), (InvocationHandler)new PACLBeanHandler(bean));
            this._paclPersistenceBeans.put(name, paclPersistenceBean);
            return paclPersistenceBean;
        }
        return bean;
    }

    protected void getInterfaces(List<Class<?>> interfaceClasses, Class<?> clazz) {
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> interfaceClass = classArray[n2];
            try {
                interfaceClasses.add(this._classLoader.loadClass(interfaceClass.getName()));
            }
            catch (ClassNotFoundException classNotFoundException) {}
            ++n2;
        }
    }

    protected Class<?>[] getInterfaces(Object object) {
        ArrayList interfaceClasses = new ArrayList();
        Class<?> clazz = object.getClass();
        this.getInterfaces(interfaceClasses, clazz);
        Class<?> superClazz = clazz.getSuperclass();
        while (superClazz != null) {
            this.getInterfaces(interfaceClasses, superClazz);
            superClazz = superClazz.getSuperclass();
        }
        return interfaceClasses.toArray(new Class[interfaceClasses.size()]);
    }
}

