/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache;

import com.liferay.portal.kernel.cache.CacheRegistry;
import com.liferay.portal.kernel.cache.CacheRegistryItem;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CacheRegistryImpl
implements CacheRegistry {
    private static Log _log = LogFactoryUtil.getLog(CacheRegistryImpl.class);
    private boolean _active = true;
    private Map<String, CacheRegistryItem> _cacheRegistryItems = new ConcurrentHashMap<String, CacheRegistryItem>();

    public void clear() {
        for (Map.Entry<String, CacheRegistryItem> entry : this._cacheRegistryItems.entrySet()) {
            CacheRegistryItem cacheRegistryItem = entry.getValue();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Invalidating " + cacheRegistryItem.getRegistryName()));
            }
            cacheRegistryItem.invalidate();
        }
    }

    public void clear(String name) {
        CacheRegistryItem cacheRegistryItem = this._cacheRegistryItems.get(name);
        if (cacheRegistryItem != null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Invalidating " + name));
            }
            cacheRegistryItem.invalidate();
        } else {
            _log.error((Object)("No cache registry found with name " + name));
        }
    }

    public boolean isActive() {
        return this._active;
    }

    public void register(CacheRegistryItem cacheRegistryItem) {
        String name = cacheRegistryItem.getRegistryName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Registering " + name));
        }
        if (this._cacheRegistryItems.containsKey(name)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Not registering duplicate " + name));
            }
        } else {
            this._cacheRegistryItems.put(name, cacheRegistryItem);
        }
    }

    public void setActive(boolean active) {
        this._active = active;
        if (!active) {
            this.clear();
        }
    }

    public void unregister(String name) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Unregistering " + name));
        }
        this._cacheRegistryItems.remove(name);
    }
}

