/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.keypool;

import com.liferay.portal.kernel.cache.CacheListener;
import com.liferay.portal.kernel.cache.CacheListenerScope;
import com.liferay.portal.kernel.cache.PortalCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiVMKeyPoolPortalCache
implements PortalCache {
    private PortalCache _clusterPortalCache;
    private PortalCache _localPortalCache;

    public MultiVMKeyPoolPortalCache(PortalCache clusterPortalCache, PortalCache localPortalCache) {
        this._clusterPortalCache = clusterPortalCache;
        this._localPortalCache = localPortalCache;
    }

    public void destroy() {
    }

    public Collection<Object> get(Collection<Serializable> keys) {
        ArrayList<Object> values = new ArrayList<Object>(keys.size());
        for (Serializable key : keys) {
            values.add(this.get(key));
        }
        return values;
    }

    public Object get(Serializable key) {
        if (key == null) {
            return null;
        }
        return this._localPortalCache.get(key);
    }

    public String getName() {
        return this._clusterPortalCache.getName();
    }

    public void put(Serializable key, Object obj) {
        this._clusterPortalCache.put(key, key);
        this._localPortalCache.put(key, obj);
    }

    public void put(Serializable key, Object obj, int timeToLive) {
        this._clusterPortalCache.put(key, key, timeToLive);
        this._localPortalCache.put(key, obj, timeToLive);
    }

    public void put(Serializable key, Serializable obj) {
        this._clusterPortalCache.put(key, key);
        this._localPortalCache.put(key, obj);
    }

    public void put(Serializable key, Serializable obj, int timeToLive) {
        this._clusterPortalCache.put(key, key, timeToLive);
        this._localPortalCache.put(key, obj, timeToLive);
    }

    public void registerCacheListener(CacheListener cacheListener) {
        this._clusterPortalCache.registerCacheListener(cacheListener);
    }

    public void registerCacheListener(CacheListener cacheListener, CacheListenerScope cacheListenerScope) {
        this._clusterPortalCache.registerCacheListener(cacheListener, cacheListenerScope);
    }

    public void remove(Serializable key) {
        this._clusterPortalCache.remove(key);
        this._localPortalCache.remove(key);
    }

    public void removeAll() {
        this._clusterPortalCache.removeAll();
        this._localPortalCache.removeAll();
    }

    public void unregisterCacheListener(CacheListener cacheListener) {
        this._clusterPortalCache.unregisterCacheListener(cacheListener);
    }

    public void unregisterCacheListeners() {
        this._clusterPortalCache.unregisterCacheListeners();
    }
}

