/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.keypool;

import com.liferay.portal.cache.keypool.MultiVMKeyPoolCacheListener;
import com.liferay.portal.cache.keypool.MultiVMKeyPoolPortalCache;
import com.liferay.portal.kernel.cache.CacheListenerScope;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.cache.SingleVMPool;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MultiVMKeyPoolPortalCacheManager
implements PortalCacheManager {
    private Map<String, MultiVMKeyPoolPortalCache> _multiVMKeyPoolPortalCaches = new ConcurrentHashMap<String, MultiVMKeyPoolPortalCache>();
    private MultiVMPool _multiVMPool;
    private SingleVMPool _singleVMPool;

    public void clearAll() {
        for (MultiVMKeyPoolPortalCache multiVMKeyPoolPortalCache : this._multiVMKeyPoolPortalCaches.values()) {
            multiVMKeyPoolPortalCache.removeAll();
        }
    }

    public PortalCache getCache(String name) {
        return this.getCache(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PortalCache getCache(String name, boolean blocking) {
        MultiVMKeyPoolPortalCache multiVMKeyPoolPortalCache = this._multiVMKeyPoolPortalCaches.get(name);
        if (multiVMKeyPoolPortalCache != null) {
            return multiVMKeyPoolPortalCache;
        }
        Map<String, MultiVMKeyPoolPortalCache> map = this._multiVMKeyPoolPortalCaches;
        synchronized (map) {
            PortalCache clusterPortalCache = this._multiVMPool.getCache(name, blocking);
            PortalCache localPortalCache = this._singleVMPool.getCache(name, blocking);
            multiVMKeyPoolPortalCache = new MultiVMKeyPoolPortalCache(clusterPortalCache, localPortalCache);
            multiVMKeyPoolPortalCache.registerCacheListener(new MultiVMKeyPoolCacheListener(localPortalCache), CacheListenerScope.REMOTE);
            this._multiVMKeyPoolPortalCaches.put(name, multiVMKeyPoolPortalCache);
        }
        return multiVMKeyPoolPortalCache;
    }

    public void reconfigureCaches(URL configurationURL) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCache(String name) {
        Map<String, MultiVMKeyPoolPortalCache> map = this._multiVMKeyPoolPortalCaches;
        synchronized (map) {
            MultiVMKeyPoolPortalCache multiVMKeyPoolPortalCache = this._multiVMKeyPoolPortalCaches.get(name);
            if (multiVMKeyPoolPortalCache != null) {
                this._multiVMPool.removeCache(name);
                this._singleVMPool.removeCache(name);
                this._multiVMKeyPoolPortalCaches.remove(name);
            }
        }
    }

    public void setMultiVMPool(MultiVMPool multiVMPool) {
        this._multiVMPool = multiVMPool;
    }

    public void setSingleVMPool(SingleVMPool singleVMPool) {
        this._singleVMPool = singleVMPool;
    }
}

