/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cluster;

import com.liferay.portal.cluster.AddressImpl;
import com.liferay.portal.cluster.ClusterBase;
import com.liferay.portal.cluster.ClusterRequestReceiver;
import com.liferay.portal.cluster.DebuggingClusterEventListenerImpl;
import com.liferay.portal.cluster.LiveUsersClusterEventListenerImpl;
import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.cluster.ClusterEvent;
import com.liferay.portal.kernel.cluster.ClusterEventListener;
import com.liferay.portal.kernel.cluster.ClusterException;
import com.liferay.portal.kernel.cluster.ClusterExecutor;
import com.liferay.portal.kernel.cluster.ClusterMessageType;
import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.cluster.ClusterNodeResponse;
import com.liferay.portal.kernel.cluster.ClusterNodeResponses;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.cluster.ClusterResponseCallback;
import com.liferay.portal.kernel.cluster.FutureClusterResponses;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.executor.PortalExecutorManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.InetAddressUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.WeakValueConcurrentHashMap;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.util.PortalPortEventListener;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterExecutorImpl
extends ClusterBase
implements ClusterExecutor,
PortalPortEventListener {
    public static final String CLUSTER_EXECUTOR_CALLBACK_THREAD_POOL = "CLUSTER_EXECUTOR_CALLBACK_THREAD_POOL";
    private static final String _DEFAULT_CLUSTER_NAME = "LIFERAY-CONTROL-CHANNEL";
    private static Log _log = LogFactoryUtil.getLog(ClusterExecutorImpl.class);
    private CopyOnWriteArrayList<ClusterEventListener> _clusterEventListeners = new CopyOnWriteArrayList();
    private Map<String, Address> _clusterNodeAddresses = new ConcurrentHashMap<String, Address>();
    private JChannel _controlJChannel;
    private ExecutorService _executorService;
    private Map<String, FutureClusterResponses> _futureClusterResponses = new WeakValueConcurrentHashMap();
    private Map<Address, ClusterNode> _liveInstances = new ConcurrentHashMap<Address, ClusterNode>();
    private Address _localAddress;
    private ClusterNode _localClusterNode;
    private boolean _shortcutLocalMethod;

    public void addClusterEventListener(ClusterEventListener clusterEventListener) {
        if (!this.isEnabled()) {
            return;
        }
        this._clusterEventListeners.addIfAbsent(clusterEventListener);
    }

    @Override
    public void afterPropertiesSet() {
        if (PropsValues.CLUSTER_EXECUTOR_DEBUG_ENABLED) {
            this.addClusterEventListener(new DebuggingClusterEventListenerImpl());
        }
        if (PropsValues.LIVE_USERS_ENABLED) {
            this.addClusterEventListener(new LiveUsersClusterEventListenerImpl());
        }
        super.afterPropertiesSet();
    }

    @Override
    public void destroy() {
        if (!this.isEnabled()) {
            return;
        }
        PortalExecutorManagerUtil.shutdown((String)CLUSTER_EXECUTOR_CALLBACK_THREAD_POOL, (boolean)true);
        this._controlJChannel.close();
    }

    public FutureClusterResponses execute(ClusterRequest clusterRequest) throws SystemException {
        if (!this.isEnabled()) {
            return null;
        }
        List<Address> addresses = this.prepareAddresses(clusterRequest);
        FutureClusterResponses futureClusterResponses = new FutureClusterResponses(addresses);
        if (!clusterRequest.isFireAndForget()) {
            String uuid = clusterRequest.getUuid();
            this._futureClusterResponses.put(uuid, futureClusterResponses);
        }
        if (!clusterRequest.isSkipLocal() && this._shortcutLocalMethod && addresses.remove(this.getLocalClusterNodeAddress())) {
            ClusterNodeResponse clusterNodeResponse = this.runLocalMethod(clusterRequest.getMethodHandler());
            clusterNodeResponse.setMulticast(clusterRequest.isMulticast());
            clusterNodeResponse.setUuid(clusterRequest.getUuid());
            futureClusterResponses.addClusterNodeResponse(clusterNodeResponse);
        }
        if (clusterRequest.isMulticast()) {
            this.sendMulticastRequest(clusterRequest);
        } else {
            this.sendUnicastRequest(clusterRequest, addresses);
        }
        return futureClusterResponses;
    }

    public void execute(ClusterRequest clusterRequest, ClusterResponseCallback clusterResponseCallback) throws SystemException {
        FutureClusterResponses futureClusterResponses = this.execute(clusterRequest);
        ClusterResponseCallbackJob clusterResponseCallbackJob = new ClusterResponseCallbackJob(clusterResponseCallback, futureClusterResponses);
        this._executorService.execute(clusterResponseCallbackJob);
    }

    public void execute(ClusterRequest clusterRequest, ClusterResponseCallback clusterResponseCallback, long timeout, TimeUnit timeUnit) throws SystemException {
        FutureClusterResponses futureClusterResponses = this.execute(clusterRequest);
        ClusterResponseCallbackJob clusterResponseCallbackJob = new ClusterResponseCallbackJob(clusterResponseCallback, futureClusterResponses, timeout, timeUnit);
        this._executorService.execute(clusterResponseCallbackJob);
    }

    public List<ClusterEventListener> getClusterEventListeners() {
        if (!this.isEnabled()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this._clusterEventListeners);
    }

    public List<Address> getClusterNodeAddresses() {
        if (!this.isEnabled()) {
            return Collections.emptyList();
        }
        return this.getAddresses(this._controlJChannel);
    }

    public List<ClusterNode> getClusterNodes() {
        if (!this.isEnabled()) {
            return Collections.emptyList();
        }
        return new ArrayList<ClusterNode>(this._liveInstances.values());
    }

    public ClusterNode getLocalClusterNode() {
        if (!this.isEnabled()) {
            return null;
        }
        return this._localClusterNode;
    }

    public Address getLocalClusterNodeAddress() {
        if (!this.isEnabled()) {
            return null;
        }
        return this._localAddress;
    }

    public void initialize() {
        if (!this.isEnabled()) {
            return;
        }
        this._executorService = PortalExecutorManagerUtil.getPortalExecutor((String)CLUSTER_EXECUTOR_CALLBACK_THREAD_POOL);
        PortalUtil.addPortalPortEventListener((PortalPortEventListener)this);
        this._localAddress = new AddressImpl(this._controlJChannel.getLocalAddress());
        try {
            this.initLocalClusterNode();
        }
        catch (SystemException se) {
            _log.error((Object)"Unable to determine local network address", (Throwable)se);
        }
        this.memberJoined(this._localAddress, this._localClusterNode);
        this.sendNotifyRequest();
        ClusterRequestReceiver clusterRequestReceiver = (ClusterRequestReceiver)this._controlJChannel.getReceiver();
        clusterRequestReceiver.openLatch();
    }

    public boolean isClusterNodeAlive(Address address) {
        if (!this.isEnabled()) {
            return false;
        }
        List<Address> addresses = this.getAddresses(this._controlJChannel);
        return addresses.contains(address);
    }

    public boolean isClusterNodeAlive(String clusterNodeId) {
        if (!this.isEnabled()) {
            return false;
        }
        return this._clusterNodeAddresses.containsKey(clusterNodeId);
    }

    @Override
    public boolean isEnabled() {
        return PropsValues.CLUSTER_LINK_ENABLED;
    }

    public void portalPortConfigured(int port) {
        if (!this.isEnabled() || this._localClusterNode.getPort() == PropsValues.PORTAL_INSTANCE_HTTP_PORT) {
            return;
        }
        try {
            this._localClusterNode.setPort(port);
            this.memberJoined(this._localAddress, this._localClusterNode);
            ClusterRequest clusterRequest = ClusterRequest.createClusterRequest((ClusterMessageType)ClusterMessageType.UPDATE, (ClusterNode)this._localClusterNode);
            this._controlJChannel.send(null, null, (Serializable)clusterRequest);
        }
        catch (Exception e2) {
            _log.error((Object)"Unable to determine configure node port", (Throwable)e2);
        }
    }

    public void removeClusterEventListener(ClusterEventListener clusterEventListener) {
        if (!this.isEnabled()) {
            return;
        }
        this._clusterEventListeners.remove(clusterEventListener);
    }

    public void setClusterEventListeners(List<ClusterEventListener> clusterEventListeners) {
        if (!this.isEnabled()) {
            return;
        }
        this._clusterEventListeners.addAllAbsent(clusterEventListeners);
    }

    public void setShortcutLocalMethod(boolean shortcutLocalMethod) {
        if (!this.isEnabled()) {
            return;
        }
        this._shortcutLocalMethod = shortcutLocalMethod;
    }

    protected void fireClusterEvent(ClusterEvent clusterEvent) {
        for (ClusterEventListener listener : this._clusterEventListeners) {
            listener.processClusterEvent(clusterEvent);
        }
    }

    protected JChannel getControlChannel() {
        return this._controlJChannel;
    }

    protected FutureClusterResponses getExecutionResults(String uuid) {
        return this._futureClusterResponses.get(uuid);
    }

    @Override
    protected void initChannels() {
        Properties controlProperties = PropsUtil.getProperties((String)"cluster.link.channel.properties.control", (boolean)false);
        String controlProperty = controlProperties.getProperty("cluster.link.channel.properties.control");
        ClusterRequestReceiver clusterRequestReceiver = new ClusterRequestReceiver(this);
        try {
            this._controlJChannel = this.createJChannel(controlProperty, clusterRequestReceiver, _DEFAULT_CLUSTER_NAME);
        }
        catch (ChannelException ce) {
            _log.error((Object)ce, (Throwable)ce);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    protected void initLocalClusterNode() throws SystemException {
        this._localClusterNode = new ClusterNode(PortalUUIDUtil.generate());
        if (PropsValues.PORTAL_INSTANCE_HTTP_PORT > 0) {
            this._localClusterNode.setPort(PropsValues.PORTAL_INSTANCE_HTTP_PORT);
        } else {
            this._localClusterNode.setPort(PortalUtil.getPortalPort((boolean)false));
        }
        try {
            InetAddress inetAddress = this.bindInetAddress;
            if (inetAddress == null) {
                inetAddress = InetAddressUtil.getLocalInetAddress();
            }
            this._localClusterNode.setInetAddress(inetAddress);
            this._localClusterNode.setHostName(inetAddress.getHostName());
        }
        catch (Exception e2) {
            throw new SystemException("Unable to determine local network address", (Throwable)e2);
        }
    }

    protected boolean isShortcutLocalMethod() {
        return this._shortcutLocalMethod;
    }

    protected void memberJoined(Address joinAddress, ClusterNode clusterNode) {
        this._liveInstances.put(joinAddress, clusterNode);
        Address previousAddress = this._clusterNodeAddresses.put(clusterNode.getClusterNodeId(), joinAddress);
        if (previousAddress == null && !this._localAddress.equals(joinAddress)) {
            ClusterEvent clusterEvent = ClusterEvent.join((ClusterNode[])new ClusterNode[]{clusterNode});
            this.fireClusterEvent(clusterEvent);
        }
    }

    protected void memberRemoved(List<Address> departAddresses) {
        ArrayList<ClusterNode> departClusterNodes = new ArrayList<ClusterNode>();
        for (Address departAddress : departAddresses) {
            ClusterNode departClusterNode = this._liveInstances.remove(departAddress);
            if (departClusterNode == null) continue;
            departClusterNodes.add(departClusterNode);
            this._clusterNodeAddresses.remove(departClusterNode.getClusterNodeId());
        }
        if (departClusterNodes.isEmpty()) {
            return;
        }
        ClusterEvent clusterEvent = ClusterEvent.depart(departClusterNodes);
        this.fireClusterEvent(clusterEvent);
    }

    protected List<Address> prepareAddresses(ClusterRequest clusterRequest) {
        boolean isMulticast = clusterRequest.isMulticast();
        ArrayList<Address> addresses = null;
        if (isMulticast) {
            addresses = this.getAddresses(this._controlJChannel);
        } else {
            Collection clusterNodeIds;
            addresses = new ArrayList();
            Collection clusterNodeAddresses = clusterRequest.getTargetClusterNodeAddresses();
            if (clusterNodeAddresses != null) {
                addresses.addAll(clusterNodeAddresses);
            }
            if ((clusterNodeIds = clusterRequest.getTargetClusterNodeIds()) != null) {
                for (String clusterNodeId : clusterNodeIds) {
                    Address address = this._clusterNodeAddresses.get(clusterNodeId);
                    addresses.add(address);
                }
            }
        }
        return addresses;
    }

    protected ClusterNodeResponse runLocalMethod(MethodHandler methodHandler) {
        ClusterNodeResponse clusterNodeResponse = new ClusterNodeResponse();
        ClusterNode localClusterNode = this.getLocalClusterNode();
        clusterNodeResponse.setAddress(this.getLocalClusterNodeAddress());
        clusterNodeResponse.setClusterNode(localClusterNode);
        clusterNodeResponse.setClusterMessageType(ClusterMessageType.EXECUTE);
        if (methodHandler == null) {
            clusterNodeResponse.setException((Exception)new ClusterException("Payload is not of type " + MethodHandler.class.getName()));
            return clusterNodeResponse;
        }
        try {
            Object returnValue = methodHandler.invoke(true);
            if (returnValue instanceof Serializable) {
                clusterNodeResponse.setResult(returnValue);
            } else if (returnValue != null) {
                clusterNodeResponse.setException((Exception)new ClusterException("Return value is not serializable"));
            }
        }
        catch (Exception e2) {
            clusterNodeResponse.setException(e2);
        }
        return clusterNodeResponse;
    }

    protected void sendMulticastRequest(ClusterRequest clusterRequest) throws SystemException {
        try {
            this._controlJChannel.send(null, null, (Serializable)clusterRequest);
        }
        catch (ChannelException ce) {
            _log.error((Object)("Unable to send multicast message " + clusterRequest), (Throwable)ce);
            throw new SystemException("Unable to send multicast request", (Throwable)ce);
        }
    }

    protected void sendNotifyRequest() {
        ClusterRequest clusterRequest = ClusterRequest.createClusterRequest((ClusterMessageType)ClusterMessageType.NOTIFY, (ClusterNode)this._localClusterNode);
        try {
            this._controlJChannel.send(null, null, (Serializable)clusterRequest);
        }
        catch (ChannelException ce) {
            _log.error((Object)"Unable to send multicast message", (Throwable)ce);
        }
    }

    protected void sendUnicastRequest(ClusterRequest clusterRequest, List<Address> addresses) throws SystemException {
        for (Address address : addresses) {
            org.jgroups.Address jGroupsAddress = (org.jgroups.Address)address.getRealAddress();
            try {
                this._controlJChannel.send(jGroupsAddress, null, (Serializable)clusterRequest);
            }
            catch (ChannelException ce) {
                _log.error((Object)("Unable to send unicast message " + clusterRequest), (Throwable)ce);
                throw new SystemException("Unable to send unicast request", (Throwable)ce);
            }
        }
    }

    private class ClusterResponseCallbackJob
    implements Runnable {
        private final ClusterResponseCallback _clusterResponseCallback;
        private final FutureClusterResponses _futureClusterResponses;
        private final long _timeout;
        private final boolean _timeoutGet;
        private final TimeUnit _timeUnit;

        public ClusterResponseCallbackJob(ClusterResponseCallback clusterResponseCallback, FutureClusterResponses futureClusterResponses) {
            this._clusterResponseCallback = clusterResponseCallback;
            this._futureClusterResponses = futureClusterResponses;
            this._timeout = -1L;
            this._timeoutGet = false;
            this._timeUnit = TimeUnit.SECONDS;
        }

        public ClusterResponseCallbackJob(ClusterResponseCallback clusterResponseCallback, FutureClusterResponses futureClusterResponses, long timeout, TimeUnit timeUnit) {
            this._clusterResponseCallback = clusterResponseCallback;
            this._futureClusterResponses = futureClusterResponses;
            this._timeout = timeout;
            this._timeoutGet = true;
            this._timeUnit = timeUnit;
        }

        public void run() {
            BlockingQueue blockingQueue = this._futureClusterResponses.getPartialResults();
            this._clusterResponseCallback.callback(blockingQueue);
            ClusterNodeResponses clusterNodeResponses = null;
            try {
                clusterNodeResponses = this._timeoutGet ? this._futureClusterResponses.get(this._timeout, this._timeUnit) : this._futureClusterResponses.get();
                this._clusterResponseCallback.callback(clusterNodeResponses);
            }
            catch (InterruptedException ie) {
                this._clusterResponseCallback.processInterruptedException(ie);
            }
            catch (TimeoutException te) {
                this._clusterResponseCallback.processTimeoutException(te);
            }
        }
    }
}

