/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cluster;

import com.liferay.portal.cluster.AddressImpl;
import com.liferay.portal.cluster.BaseReceiver;
import com.liferay.portal.cluster.ClusterExecutorImpl;
import com.liferay.portal.cluster.ClusterInvokeThreadLocal;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.cluster.ClusterException;
import com.liferay.portal.kernel.cluster.ClusterMessageType;
import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.cluster.ClusterNodeResponse;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.cluster.FutureClusterResponses;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.pacl.PACLClassLoaderUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterRequestReceiver
extends BaseReceiver {
    private static Log _log = LogFactoryUtil.getLog(ClusterRequestReceiver.class);
    private ClusterExecutorImpl _clusterExecutorImpl;
    private CountDownLatch _countDownLatch = new CountDownLatch(1);
    private volatile View _lastView;

    public ClusterRequestReceiver(ClusterExecutorImpl clusterExecutorImpl) {
        this._clusterExecutorImpl = clusterExecutorImpl;
    }

    public void openLatch() {
        this._countDownLatch.countDown();
    }

    @Override
    public void receive(Message message) {
        boolean isProcessed;
        try {
            this._countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            _log.error((Object)"Latch opened prematurely by interruption. Dependence may not be ready.");
        }
        JChannel controlChannel = this._clusterExecutorImpl.getControlChannel();
        org.jgroups.Address localAddress = controlChannel.getAddress();
        Object obj = message.getObject();
        if (obj == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Message content is null");
            }
            return;
        }
        org.jgroups.Address sourceAddress = message.getSrc();
        if (localAddress.equals(sourceAddress) && (isProcessed = this.processLocalMessage(obj, sourceAddress))) {
            return;
        }
        if (obj instanceof ClusterRequest) {
            ClusterRequest clusterRequest = (ClusterRequest)obj;
            this.processClusterRequest(clusterRequest, sourceAddress, localAddress);
        } else if (obj instanceof ClusterNodeResponse) {
            ClusterNodeResponse clusterNodeResponse = (ClusterNodeResponse)obj;
            this.processClusterResponse(clusterNodeResponse, sourceAddress, localAddress);
        } else if (_log.isWarnEnabled()) {
            _log.warn((Object)("Unable to process message content of type " + obj.getClass()));
        }
    }

    @Override
    public void viewAccepted(View view) {
        super.viewAccepted(view);
        if (this._lastView == null) {
            this._lastView = view;
            return;
        }
        List<Address> departAddresses = this.getDepartAddresses(view);
        List<Address> newAddresses = this.getNewAddresses(view);
        this._lastView = view;
        try {
            this._countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            _log.error((Object)"Latch opened prematurely by interruption. Dependence may not be ready.");
        }
        if (!newAddresses.isEmpty()) {
            this._clusterExecutorImpl.sendNotifyRequest();
        }
        if (!departAddresses.isEmpty()) {
            this._clusterExecutorImpl.memberRemoved(departAddresses);
        }
    }

    protected List<Address> getDepartAddresses(View view) {
        Vector currentJGroupsAddresses = view.getMembers();
        Vector lastJGroupsAddresses = this._lastView.getMembers();
        ArrayList departJGroupsAddresses = new ArrayList(lastJGroupsAddresses);
        departJGroupsAddresses.removeAll(currentJGroupsAddresses);
        if (departJGroupsAddresses.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Address> departAddresses = new ArrayList<Address>(departJGroupsAddresses.size());
        for (org.jgroups.Address departJGroupsAddress : departJGroupsAddresses) {
            AddressImpl departAddress = new AddressImpl(departJGroupsAddress);
            departAddresses.add(departAddress);
        }
        return departAddresses;
    }

    protected List<Address> getNewAddresses(View view) {
        Vector currentJGroupsAddresses = view.getMembers();
        Vector lastJGroupsAddresses = this._lastView.getMembers();
        ArrayList newJGroupsAddresses = new ArrayList(currentJGroupsAddresses);
        newJGroupsAddresses.removeAll(lastJGroupsAddresses);
        if (newJGroupsAddresses.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Address> newAddresses = new ArrayList<Address>(newJGroupsAddresses.size());
        for (org.jgroups.Address newJGroupsAddress : newJGroupsAddresses) {
            AddressImpl newAddress = new AddressImpl(newJGroupsAddress);
            newAddresses.add(newAddress);
        }
        return newAddresses;
    }

    protected Object invoke(String servletContextName, String beanIdentifier, MethodHandler methodHandler) throws Exception {
        if (servletContextName == null) {
            if (Validator.isNull((String)beanIdentifier)) {
                return methodHandler.invoke(true);
            }
            Object bean = PortalBeanLocatorUtil.locate((String)beanIdentifier);
            return methodHandler.invoke(bean);
        }
        ClassLoader contextClassLoader = PACLClassLoaderUtil.getContextClassLoader();
        try {
            ClassLoader classLoader = (ClassLoader)PortletBeanLocatorUtil.locate((String)servletContextName, (String)"portletClassLoader");
            PACLClassLoaderUtil.setContextClassLoader(classLoader);
            if (Validator.isNull((String)beanIdentifier)) {
                Object object = methodHandler.invoke(true);
                return object;
            }
            Object bean = PortletBeanLocatorUtil.locate((String)servletContextName, (String)beanIdentifier);
            Object object = methodHandler.invoke(bean);
            return object;
        }
        catch (Exception e2) {
            throw e2;
        }
        finally {
            PACLClassLoaderUtil.setContextClassLoader(contextClassLoader);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processClusterRequest(ClusterRequest clusterRequest, org.jgroups.Address sourceAddress, org.jgroups.Address localAddress) {
        ClusterNodeResponse clusterNodeResponse;
        block15: {
            ClusterMessageType clusterMessageType = clusterRequest.getClusterMessageType();
            clusterNodeResponse = new ClusterNodeResponse();
            AddressImpl address = new AddressImpl(localAddress);
            clusterNodeResponse.setAddress((Address)address);
            ClusterNode localClusterNode = this._clusterExecutorImpl.getLocalClusterNode();
            clusterNodeResponse.setClusterNode(localClusterNode);
            if (clusterMessageType.equals((Object)ClusterMessageType.NOTIFY) || clusterMessageType.equals((Object)ClusterMessageType.UPDATE)) {
                ClusterNode originatingClusterNode = clusterRequest.getOriginatingClusterNode();
                if (originatingClusterNode == null) {
                    if (!_log.isWarnEnabled()) return;
                    _log.warn((Object)"Content of notify message does not contain cluster node information");
                    return;
                }
                this._clusterExecutorImpl.memberJoined(new AddressImpl(sourceAddress), originatingClusterNode);
                clusterNodeResponse.setClusterMessageType(clusterMessageType);
            } else {
                clusterNodeResponse.setClusterMessageType(ClusterMessageType.EXECUTE);
                clusterNodeResponse.setMulticast(clusterRequest.isMulticast());
                clusterNodeResponse.setUuid(clusterRequest.getUuid());
                MethodHandler methodHandler = clusterRequest.getMethodHandler();
                if (methodHandler != null) {
                    block14: {
                        try {
                            try {
                                ClusterInvokeThreadLocal.setEnabled(false);
                                Object returnValue = this.invoke(clusterRequest.getServletContextName(), clusterRequest.getBeanIdentifier(), methodHandler);
                                if (returnValue instanceof Serializable) {
                                    clusterNodeResponse.setResult(returnValue);
                                    break block14;
                                }
                                if (returnValue != null) {
                                    clusterNodeResponse.setException((Exception)new ClusterException("Return value is not serializable"));
                                }
                            }
                            catch (Exception e2) {
                                clusterNodeResponse.setException(e2);
                                _log.error((Object)("Failed to invoke method " + methodHandler), (Throwable)e2);
                                ClusterInvokeThreadLocal.setEnabled(true);
                                break block15;
                            }
                        }
                        catch (Throwable throwable) {
                            ClusterInvokeThreadLocal.setEnabled(true);
                            throw throwable;
                        }
                    }
                    ClusterInvokeThreadLocal.setEnabled(true);
                } else {
                    clusterNodeResponse.setException((Exception)new ClusterException("Payload is not of type " + MethodHandler.class.getName()));
                }
            }
        }
        JChannel controlChannel = this._clusterExecutorImpl.getControlChannel();
        try {
            controlChannel.send(sourceAddress, localAddress, (Serializable)clusterNodeResponse);
            return;
        }
        catch (ChannelException ce) {
            _log.error((Object)("Unable to send response message " + clusterNodeResponse), (Throwable)ce);
            return;
        }
        catch (Throwable t) {
            _log.error((Object)t, t);
        }
    }

    protected void processClusterResponse(ClusterNodeResponse clusterNodeResponse, org.jgroups.Address sourceAddress, org.jgroups.Address localAddress) {
        ClusterMessageType clusterMessageType = clusterNodeResponse.getClusterMessageType();
        if (clusterMessageType.equals((Object)ClusterMessageType.NOTIFY) || clusterMessageType.equals((Object)ClusterMessageType.UPDATE)) {
            ClusterNode clusterNode = clusterNodeResponse.getClusterNode();
            if (clusterNode != null) {
                AddressImpl joinAddress = new AddressImpl(sourceAddress);
                this._clusterExecutorImpl.memberJoined(joinAddress, clusterNode);
            } else if (_log.isWarnEnabled()) {
                _log.warn((Object)"Response of notify message does not contain cluster node information");
            }
            return;
        }
        String uuid = clusterNodeResponse.getUuid();
        FutureClusterResponses futureClusterResponses = this._clusterExecutorImpl.getExecutionResults(uuid);
        if (futureClusterResponses == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Unable to find response container for " + uuid));
            }
            return;
        }
        AddressImpl address = new AddressImpl(sourceAddress);
        if (futureClusterResponses.expectsReply((Address)address)) {
            futureClusterResponses.addClusterNodeResponse(clusterNodeResponse);
        } else if (_log.isWarnEnabled()) {
            _log.warn((Object)("Unknown uuid " + uuid + " from " + sourceAddress));
        }
    }

    protected boolean processLocalMessage(Object message, org.jgroups.Address sourceAddress) {
        ClusterRequest clusterRequest;
        if (message instanceof ClusterRequest && (clusterRequest = (ClusterRequest)message).isSkipLocal()) {
            return true;
        }
        return this._clusterExecutorImpl.isShortcutLocalMethod();
    }
}

