/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.convert;

import com.liferay.portal.convert.ConvertProcess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.util.MaintenanceUtil;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.portlet.wiki.translators.ClassicToCreoleTranslator;
import java.util.List;

public class ConvertWikiCreole
extends ConvertProcess {
    private static Log _log = LogFactoryUtil.getLog(ConvertWikiCreole.class);

    public String getDescription() {
        return "convert-wiki-pages-from-classic-wiki-to-creole-format";
    }

    public boolean isEnabled() {
        boolean enabled = false;
        try {
            int pagesCount = WikiPageLocalServiceUtil.getPagesCount((String)"classic_wiki");
            if (pagesCount > 0) {
                enabled = true;
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        return enabled;
    }

    protected void doConvert() throws Exception {
        List pages = WikiPageLocalServiceUtil.getPages((String)"classic_wiki");
        ClassicToCreoleTranslator translator = new ClassicToCreoleTranslator();
        MaintenanceUtil.appendStatus("Converting " + pages.size() + " Wiki pages from Classic Wiki to Creole format");
        int i2 = 0;
        while (i2 < pages.size()) {
            if (i2 > 0 && i2 % (pages.size() / 4) == 0) {
                MaintenanceUtil.appendStatus(String.valueOf((double)i2 * 100.0 / (double)pages.size()) + "%");
            }
            WikiPage page = (WikiPage)pages.get(i2);
            page.setFormat("creole");
            page.setContent(translator.translate(page.getContent()));
            WikiPageLocalServiceUtil.updateWikiPage((WikiPage)page);
            ++i2;
        }
    }
}

