/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.convert.action;

import com.liferay.portal.NoSuchRoleException;
import com.liferay.portal.RolePermissionsException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.struts.PortletAction;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditPermissionsAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("merge")) {
                this.merge(actionRequest, actionResponse);
            } else if (cmd.equals("reassign")) {
                this.reassign(actionRequest, actionResponse);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchRoleException || e2 instanceof PrincipalException || e2 instanceof RolePermissionsException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e2.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.admin.error");
            }
            throw e2;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.admin.edit_permissions"));
    }

    protected void merge(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long[] roleIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"roleIds"), (long)0L);
        long toRoleId = roleIds[0];
        int i2 = 1;
        while (i2 < roleIds.length) {
            long fromRoleId = roleIds[i2];
            ResourcePermissionLocalServiceUtil.mergePermissions((long)fromRoleId, (long)toRoleId);
            ++i2;
        }
    }

    protected void reassign(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long resourcePermissionId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"resourcePermissionId");
        long toRoleId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"toRoleId");
        ResourcePermissionLocalServiceUtil.reassignPermissions((long)resourcePermissionId, (long)toRoleId);
    }
}

