/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.jdbc.pacl;

import com.liferay.portal.dao.jdbc.pacl.PACLStatementHandler;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.security.lang.PortalSecurityManagerThreadLocal;
import com.liferay.portal.security.pacl.PACLPolicy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PACLConnectionHandler
implements InvocationHandler {
    private Connection _connection;
    private PACLPolicy _paclPolicy;

    public PACLConnectionHandler(Connection connection, PACLPolicy paclPolicy) {
        this._connection = connection;
        this._paclPolicy = paclPolicy;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        try {
            String sql;
            String methodName = method.getName();
            if (methodName.equals("equals")) {
                if (proxy == arguments[0]) {
                    return true;
                }
                return false;
            }
            if (methodName.equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if ((methodName.equals("prepareCall") || methodName.equals("prepareStatement")) && !this._paclPolicy.hasSQL(sql = (String)arguments[0])) {
                throw new SecurityException("Attempted to execute unapproved SQL " + sql);
            }
            boolean enabled = PortalSecurityManagerThreadLocal.isEnabled();
            Object returnValue = null;
            try {
                PortalSecurityManagerThreadLocal.setEnabled(false);
                returnValue = method.invoke((Object)this._connection, arguments);
            }
            finally {
                PortalSecurityManagerThreadLocal.setEnabled(enabled);
            }
            if (methodName.equals("createStatement") || methodName.equals("prepareCall") || methodName.equals("prepareStatement")) {
                Statement statement = (Statement)returnValue;
                return ProxyUtil.newProxyInstance((ClassLoader)this._paclPolicy.getClassLoader(), (Class[])this.getInterfaces(returnValue.getClass()), (InvocationHandler)new PACLStatementHandler(statement, this._paclPolicy));
            }
            return returnValue;
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    protected Class<?>[] getInterfaces(Class<?> returnType) {
        ArrayList<Class<PreparedStatement>> interfaceClasses = new ArrayList<Class<PreparedStatement>>();
        interfaceClasses.add(Statement.class);
        if (!CallableStatement.class.isAssignableFrom(returnType)) {
            interfaceClasses.add(CallableStatement.class);
        } else if (!PreparedStatement.class.isAssignableFrom(returnType)) {
            interfaceClasses.add(PreparedStatement.class);
        }
        return interfaceClasses.toArray(new Class[interfaceClasses.size()]);
    }
}

