/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.jdbc.pacl;

import com.liferay.portal.dao.jdbc.pacl.PACLConnectionHandler;
import com.liferay.portal.dao.jdbc.util.DataSourceWrapper;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.security.lang.PortalSecurityManagerThreadLocal;
import com.liferay.portal.security.pacl.PACLClassUtil;
import com.liferay.portal.security.pacl.PACLPolicy;
import com.liferay.portal.security.pacl.PACLPolicyManager;
import java.lang.reflect.InvocationHandler;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class PACLDataSource
extends DataSourceWrapper {
    private static Log _log = LogFactoryUtil.getLog((String)PACLDataSource.class.getName());
    private DataSource _dataSource;

    public PACLDataSource(DataSource dataSource) {
        super(dataSource);
        this._dataSource = dataSource;
        _log.debug((Object)("Loading " + PACLConnectionHandler.class.getName()));
    }

    public Connection getConnection() throws SQLException {
        Connection connection = this._dataSource.getConnection();
        if (!(PACLPolicyManager.isActive() && PortalSecurityManagerThreadLocal.isCheckSQL() && PortalSecurityManagerThreadLocal.isEnabled())) {
            return connection;
        }
        PACLPolicy paclPolicy = PACLClassUtil.getPACLPolicy(false, _log.isDebugEnabled());
        if (paclPolicy == null || !paclPolicy.isActive()) {
            return connection;
        }
        return (Connection)ProxyUtil.newProxyInstance((ClassLoader)paclPolicy.getClassLoader(), (Class[])new Class[]{Connection.class}, (InvocationHandler)new PACLConnectionHandler(connection, paclPolicy));
    }
}

