/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.jdbc.pacl;

import com.liferay.portal.security.lang.PortalSecurityManagerThreadLocal;
import com.liferay.portal.security.pacl.PACLPolicy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Statement;

public class PACLStatementHandler
implements InvocationHandler {
    private PACLPolicy _paclPolicy;
    private Statement _statement;

    public PACLStatementHandler(Statement statement, PACLPolicy paclPolicy) {
        this._statement = statement;
        this._paclPolicy = paclPolicy;
    }

    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        Object object;
        String methodName = method.getName();
        if (methodName.equals("addBatch") || methodName.equals("execute") || methodName.equals("executeQuery") || methodName.equals("executeUpdate")) {
            String sql;
            if (arguments != null && arguments.length > 0 && !this._paclPolicy.hasSQL(sql = (String)arguments[0])) {
                throw new SecurityException("Attempted to execute unapproved SQL " + sql);
            }
        } else {
            if (methodName.equals("equals")) {
                if (proxy == arguments[0]) {
                    return true;
                }
                return false;
            }
            if (methodName.equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
        }
        boolean enabled = PortalSecurityManagerThreadLocal.isEnabled();
        try {
            PortalSecurityManagerThreadLocal.setEnabled(false);
            object = method.invoke((Object)this._statement, arguments);
        }
        catch (Throwable throwable) {
            try {
                PortalSecurityManagerThreadLocal.setEnabled(enabled);
                throw throwable;
            }
            catch (InvocationTargetException ite) {
                throw ite.getTargetException();
            }
        }
        PortalSecurityManagerThreadLocal.setEnabled(enabled);
        return object;
    }
}

