/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.jdbc.util;

import com.liferay.portal.dao.jdbc.util.DataSourceWrapper;
import com.liferay.portal.dao.orm.hibernate.PortletSessionFactoryImpl;
import com.liferay.portal.dao.orm.hibernate.SessionFactoryImpl;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.dao.jdbc.DataSourceFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletClassLoaderUtil;
import com.liferay.portal.security.pacl.PACLClassLoaderUtil;
import com.liferay.portal.spring.hibernate.PortalHibernateConfiguration;
import com.liferay.portal.spring.hibernate.PortletHibernateConfiguration;
import com.liferay.portal.spring.jpa.LocalContainerEntityManagerFactoryBean;
import com.liferay.portal.util.PropsValues;
import java.util.List;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.hibernate.SessionFactory;
import org.hibernate.engine.SessionFactoryImplementor;
import org.springframework.orm.hibernate3.HibernateTransactionManager;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;

public class DataSourceSwapper {
    private static Log _log = LogFactoryUtil.getLog(DataSourceSwapper.class);
    private static DataSourceWrapper _counterDataSourceWrapper;
    private static DataSourceWrapper _liferayDataSourceWrapper;

    public static void swapCounterDataSource(Properties properties) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Create new counter data source");
        }
        DataSource newDataSource = DataSourceFactoryUtil.initDataSource((Properties)properties);
        DataSource oldDataSource = _counterDataSourceWrapper.getWrappedDataSource();
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Set new counter data source");
        }
        _counterDataSourceWrapper.setWrappedDataSource(newDataSource);
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Destroy old counter data source");
        }
        DataSourceFactoryUtil.destroyDataSource((DataSource)oldDataSource);
        if (PropsValues.PERSISTENCE_PROVIDER.equalsIgnoreCase("jpa")) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Reinitialize Hibernate for new counter data source");
            }
            DataSourceSwapper._reinitializeJPA("counterSessionFactory", newDataSource);
        } else {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Reinitialize JPA for new counter data source");
            }
            DataSourceSwapper._reinitializeHibernate("counterSessionFactory", newDataSource);
        }
    }

    public static void swapLiferayDataSource(Properties properties) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Create new liferay data source");
        }
        DataSource newDataSource = DataSourceFactoryUtil.initDataSource((Properties)properties);
        DataSource oldDataSource = _liferayDataSourceWrapper.getWrappedDataSource();
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Set new liferay data source");
        }
        _liferayDataSourceWrapper.setWrappedDataSource(newDataSource);
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Destroy old liferay data source");
        }
        DataSourceFactoryUtil.destroyDataSource((DataSource)oldDataSource);
        if (PropsValues.PERSISTENCE_PROVIDER.equalsIgnoreCase("jpa")) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Reinitialize Hibernate for new liferay data source");
            }
            DataSourceSwapper._reinitializeJPA("liferaySessionFactory", newDataSource);
        } else {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Reinitialize JPA for new liferay data source");
            }
            DataSourceSwapper._reinitializeHibernate("liferaySessionFactory", newDataSource);
        }
        DataSourceSwapper._reinitializePortletsHibernate(newDataSource);
    }

    public void setCounterDataSourceWrapper(DataSourceWrapper counterDataSourceWrapper) {
        _counterDataSourceWrapper = counterDataSourceWrapper;
    }

    public void setLiferayDataSourceWrapper(DataSourceWrapper liferayDataSourceWrapper) {
        _liferayDataSourceWrapper = liferayDataSourceWrapper;
    }

    private static void _reinitializeHibernate(String name, DataSource dataSource) throws Exception {
        PortalHibernateConfiguration portalHibernateConfiguration = new PortalHibernateConfiguration();
        portalHibernateConfiguration.setDataSource(dataSource);
        portalHibernateConfiguration.afterPropertiesSet();
        SessionFactoryImplementor sessionFactoryImplementor = (SessionFactoryImplementor)portalHibernateConfiguration.getObject();
        SessionFactoryImpl sessionFactoryImpl = (SessionFactoryImpl)PortalBeanLocatorUtil.locate((String)name);
        sessionFactoryImpl.setSessionFactoryImplementor(sessionFactoryImplementor);
        AbstractPlatformTransactionManager abstractPlatformTransactionManager = (AbstractPlatformTransactionManager)PortalBeanLocatorUtil.locate((String)"liferayTransactionManager");
        if (abstractPlatformTransactionManager instanceof HibernateTransactionManager) {
            HibernateTransactionManager hibernateTransactionManager = (HibernateTransactionManager)abstractPlatformTransactionManager;
            hibernateTransactionManager.setSessionFactory((SessionFactory)sessionFactoryImplementor);
        } else if (_log.isWarnEnabled()) {
            _log.warn((Object)("Unable to swap to session factory for " + abstractPlatformTransactionManager.getClass() + " which may cause subsequent transaction failures"));
        }
    }

    private static void _reinitializeJPA(String name, DataSource dataSource) throws Exception {
        LocalContainerEntityManagerFactoryBean localContainerEntityManagerFactoryBean = new LocalContainerEntityManagerFactoryBean();
        localContainerEntityManagerFactoryBean.setDataSource(dataSource);
        localContainerEntityManagerFactoryBean.afterPropertiesSet();
        EntityManagerFactory entityManagerFactory = localContainerEntityManagerFactoryBean.getObject();
        com.liferay.portal.dao.orm.jpa.SessionFactoryImpl sessionFactoryImpl = (com.liferay.portal.dao.orm.jpa.SessionFactoryImpl)PortalBeanLocatorUtil.locate((String)name);
        sessionFactoryImpl.setEntityManagerFactory(entityManagerFactory);
    }

    private static void _reinitializePortletsHibernate(DataSource newDataSource) throws Exception {
        List<PortletSessionFactoryImpl> portletSessionFactoryImpls = SessionFactoryImpl.getPortletSessionFactories();
        for (PortletSessionFactoryImpl portletSessionFactoryImpl : portletSessionFactoryImpls) {
            ClassLoader oldPortletClassLoader = PortletClassLoaderUtil.getClassLoader();
            ClassLoader portletClassLoader = portletSessionFactoryImpl.getSessionFactoryClassLoader();
            PortletClassLoaderUtil.setClassLoader((ClassLoader)portletClassLoader);
            ClassLoader contextClassLoader = PACLClassLoaderUtil.getContextClassLoader();
            PACLClassLoaderUtil.setContextClassLoader(portletClassLoader);
            try {
                PortletHibernateConfiguration portletHibernateConfiguration = new PortletHibernateConfiguration();
                portletHibernateConfiguration.setDataSource(newDataSource);
                portletHibernateConfiguration.afterPropertiesSet();
                SessionFactoryImplementor sessionFactoryImplementor = (SessionFactoryImplementor)portletHibernateConfiguration.getObject();
                portletSessionFactoryImpl.setSessionFactoryImplementor(sessionFactoryImplementor);
            }
            finally {
                PortletClassLoaderUtil.setClassLoader((ClassLoader)oldPortletClassLoader);
                PACLClassLoaderUtil.setContextClassLoader(contextClassLoader);
            }
        }
    }
}

