/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.common;

import com.liferay.portal.kernel.cache.CacheRegistryItem;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections.map.LRUMap;

public class FinderCacheImpl
implements CacheRegistryItem,
FinderCache {
    public static final String CACHE_NAME = FinderCache.class.getName();
    private static final String _GROUP_KEY_PREFIX = CACHE_NAME.concat(".");
    private static ThreadLocal<LRUMap> _localCache;
    private static boolean _localCacheAvailable;
    private MultiVMPool _multiVMPool;
    private ConcurrentMap<String, PortalCache> _portalCaches = new ConcurrentHashMap<String, PortalCache>();

    static {
        if (PropsValues.VALUE_OBJECT_FINDER_THREAD_LOCAL_CACHE_MAX_SIZE > 0) {
            _localCache = new AutoResetThreadLocal(FinderCacheImpl.class + "._localCache", (Object)new LRUMap(PropsValues.VALUE_OBJECT_FINDER_THREAD_LOCAL_CACHE_MAX_SIZE));
            _localCacheAvailable = true;
        }
    }

    public void afterPropertiesSet() {
        CacheRegistryUtil.register((CacheRegistryItem)this);
    }

    public void clearCache() {
        this.clearLocalCache();
        for (PortalCache portalCache : this._portalCaches.values()) {
            portalCache.removeAll();
        }
    }

    public void clearCache(String className) {
        this.clearLocalCache();
        PortalCache portalCache = this._getPortalCache(className, false);
        if (portalCache != null) {
            portalCache.removeAll();
        }
    }

    public void clearLocalCache() {
        if (_localCacheAvailable) {
            _localCache.remove();
        }
    }

    public String getRegistryName() {
        return CACHE_NAME;
    }

    public Object getResult(FinderPath finderPath, Object[] args, SessionFactory sessionFactory) {
        Serializable cacheKey;
        PortalCache portalCache;
        if (!(PropsValues.VALUE_OBJECT_FINDER_CACHE_ENABLED && finderPath.isFinderCacheEnabled() && CacheRegistryUtil.isActive())) {
            return null;
        }
        Object primaryKey = null;
        Map localCache = null;
        Serializable localCacheKey = null;
        if (_localCacheAvailable) {
            localCache = (Map)_localCache.get();
            localCacheKey = finderPath.encodeLocalCacheKey(args);
            primaryKey = localCache.get(localCacheKey);
        }
        if (primaryKey == null && (primaryKey = (portalCache = this._getPortalCache(finderPath.getCacheName(), true)).get(cacheKey = finderPath.encodeCacheKey(args))) != null && _localCacheAvailable) {
            localCache.put(localCacheKey, primaryKey);
        }
        if (primaryKey != null) {
            return this._primaryKeyToResult(finderPath, sessionFactory, primaryKey);
        }
        return null;
    }

    public void invalidate() {
        this.clearCache();
    }

    public void putResult(FinderPath finderPath, Object[] args, Object result) {
        if (!(PropsValues.VALUE_OBJECT_FINDER_CACHE_ENABLED && finderPath.isFinderCacheEnabled() && CacheRegistryUtil.isActive() && result != null)) {
            return;
        }
        Object primaryKey = this._resultToPrimaryKey(result);
        if (_localCacheAvailable) {
            Map localCache = (Map)_localCache.get();
            Serializable localCacheKey = finderPath.encodeLocalCacheKey(args);
            localCache.put(localCacheKey, primaryKey);
        }
        PortalCache portalCache = this._getPortalCache(finderPath.getCacheName(), true);
        Serializable cacheKey = finderPath.encodeCacheKey(args);
        portalCache.put(cacheKey, primaryKey);
    }

    public void removeCache(String className) {
        this._portalCaches.remove(className);
        String groupKey = _GROUP_KEY_PREFIX.concat(className);
        this._multiVMPool.removeCache(groupKey);
    }

    public void removeResult(FinderPath finderPath, Object[] args) {
        if (!(PropsValues.VALUE_OBJECT_FINDER_CACHE_ENABLED && finderPath.isFinderCacheEnabled() && CacheRegistryUtil.isActive())) {
            return;
        }
        if (_localCacheAvailable) {
            Map localCache = (Map)_localCache.get();
            Serializable localCacheKey = finderPath.encodeLocalCacheKey(args);
            localCache.remove(localCacheKey);
        }
        PortalCache portalCache = this._getPortalCache(finderPath.getCacheName(), true);
        Serializable cacheKey = finderPath.encodeCacheKey(args);
        portalCache.remove(cacheKey);
    }

    public void setMultiVMPool(MultiVMPool multiVMPool) {
        this._multiVMPool = multiVMPool;
    }

    private PortalCache _getPortalCache(String className, boolean createIfAbsent) {
        String groupKey;
        PortalCache previousPortalCache;
        PortalCache portalCache = (PortalCache)this._portalCaches.get(className);
        if (portalCache == null && createIfAbsent && (previousPortalCache = this._portalCaches.putIfAbsent(className, portalCache = this._multiVMPool.getCache(groupKey = _GROUP_KEY_PREFIX.concat(className), PropsValues.VALUE_OBJECT_FINDER_BLOCKING_CACHE))) != null) {
            portalCache = previousPortalCache;
        }
        return portalCache;
    }

    private Object _primaryKeyToResult(FinderPath finderPath, SessionFactory sessionFactory, Object primaryKey) {
        if (primaryKey instanceof List) {
            List cachedList = (List)primaryKey;
            if (cachedList.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Object> list = new ArrayList<Object>(cachedList.size());
            for (Object curPrimaryKey : cachedList) {
                Object result = this._primaryKeyToResult(finderPath, sessionFactory, curPrimaryKey);
                list.add(result);
            }
            return list;
        }
        if (BaseModel.class.isAssignableFrom(finderPath.getResultClass())) {
            return EntityCacheUtil.loadResult((boolean)finderPath.isEntityCacheEnabled(), (Class)finderPath.getResultClass(), (Serializable)((Serializable)primaryKey), (SessionFactory)sessionFactory);
        }
        return primaryKey;
    }

    private Object _resultToPrimaryKey(Object result) {
        if (result instanceof BaseModel) {
            BaseModel model = (BaseModel)result;
            return model.getPrimaryKeyObj();
        }
        if (result instanceof List) {
            List list = (List)result;
            if (list.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Object> cachedList = new ArrayList<Object>(list.size());
            for (Object curResult : list) {
                Object primaryKey = this._resultToPrimaryKey(curResult);
                cachedList.add(primaryKey);
            }
            return cachedList;
        }
        return result;
    }
}

