/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate;

import com.liferay.portal.dao.orm.hibernate.DynamicQueryImpl;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.permission.PortalServicePermission;
import com.liferay.portal.security.pacl.PACLClassLoaderUtil;
import java.security.Permission;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.criterion.DetachedCriteria;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicQueryFactoryImpl
implements DynamicQueryFactory {
    private static Log _log = LogFactoryUtil.getLog(DynamicQueryFactoryImpl.class);
    private Map<ClassLoader, Map<String, Class<?>>> _classes = new HashMap();
    private ClassLoader _portalClassLoader = DynamicQueryFactoryImpl.class.getClassLoader();

    public DynamicQuery forClass(Class<?> clazz) {
        clazz = this.getImplClass(clazz, null);
        return new DynamicQueryImpl(DetachedCriteria.forClass(clazz));
    }

    public DynamicQuery forClass(Class<?> clazz, ClassLoader classLoader) {
        clazz = this.getImplClass(clazz, classLoader);
        return new DynamicQueryImpl(DetachedCriteria.forClass(clazz));
    }

    public DynamicQuery forClass(Class<?> clazz, String alias) {
        clazz = this.getImplClass(clazz, null);
        return new DynamicQueryImpl(DetachedCriteria.forClass(clazz, (String)alias));
    }

    public DynamicQuery forClass(Class<?> clazz, String alias, ClassLoader classLoader) {
        clazz = this.getImplClass(clazz, classLoader);
        return new DynamicQueryImpl(DetachedCriteria.forClass(clazz, (String)alias));
    }

    protected Class<?> getImplClass(Class<?> clazz, ClassLoader classLoader) {
        SecurityManager securityManager;
        Class<?> implClass = clazz;
        String className = clazz.getName();
        if (!className.endsWith("Impl")) {
            if (classLoader == null) {
                classLoader = PACLClassLoaderUtil.getContextClassLoader();
            }
            Package pkg = clazz.getPackage();
            String implClassName = String.valueOf(pkg.getName()) + ".impl." + clazz.getSimpleName() + "Impl";
            try {
                implClass = this.getImplClass(implClassName, classLoader);
            }
            catch (Exception e1) {
                if (classLoader != this._portalClassLoader) {
                    try {
                        implClass = this.getImplClass(implClassName, this._portalClassLoader);
                    }
                    catch (Exception e2) {
                        _log.error((Object)("Unable find model " + implClassName), (Throwable)e2);
                    }
                }
                _log.error((Object)("Unable find model " + implClassName), (Throwable)e1);
            }
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            PortalServicePermission permission = new PortalServicePermission("dynamicQuery", implClass, null);
            securityManager.checkPermission((Permission)permission);
        }
        return implClass;
    }

    protected Class<?> getImplClass(String implClassName, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> clazz;
        Map<String, Class<?>> classes = this._classes.get(classLoader);
        if (classes == null) {
            classes = new HashMap();
            this._classes.put(classLoader, classes);
        }
        if ((clazz = classes.get(implClassName)) == null) {
            clazz = classLoader.loadClass(implClassName);
            classes.put(implClassName, clazz);
        }
        return clazz;
    }
}

