/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate.region;

import com.liferay.portal.cache.ehcache.EhcacheConfigurationUtil;
import com.liferay.portal.cache.ehcache.ModifiableEhcacheWrapper;
import com.liferay.portal.dao.orm.hibernate.region.CollectionRegionWrapper;
import com.liferay.portal.dao.orm.hibernate.region.EntityRegionWrapper;
import com.liferay.portal.dao.orm.hibernate.region.MBeanRegisteringPortalLifecycle;
import com.liferay.portal.dao.orm.hibernate.region.QueryResultsRegionWrapper;
import com.liferay.portal.dao.orm.hibernate.region.TimestampsRegionWrapper;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.Validator;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.hibernate.EhCacheRegionFactory;
import net.sf.ehcache.hibernate.regions.EhcacheCollectionRegion;
import net.sf.ehcache.hibernate.regions.EhcacheEntityRegion;
import net.sf.ehcache.hibernate.regions.EhcacheQueryResultsRegion;
import net.sf.ehcache.hibernate.regions.EhcacheTimestampsRegion;
import net.sf.ehcache.util.FailSafeTimer;
import org.hibernate.cache.CacheDataDescription;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CollectionRegion;
import org.hibernate.cache.EntityRegion;
import org.hibernate.cache.QueryResultsRegion;
import org.hibernate.cache.TimestampsRegion;
import org.hibernate.cfg.Settings;

public class LiferayEhcacheRegionFactory
extends EhCacheRegionFactory {
    private static final String _DEFAULT_CLUSTERED_EHCACHE_CONFIG_FILE = "/ehcache/hibernate-clustered.xml";
    private static Log _log = LogFactoryUtil.getLog(LiferayEhcacheRegionFactory.class);
    private MBeanRegisteringPortalLifecycle _mBeanRegisteringPortalLifecycle;
    private boolean _usingDefault;

    public LiferayEhcacheRegionFactory(Properties properties) {
        super(properties);
    }

    public CollectionRegion buildCollectionRegion(String regionName, Properties properties, CacheDataDescription cacheDataDescription) throws CacheException {
        this.configureCache(regionName);
        EhcacheCollectionRegion ehcacheCollectionRegion = (EhcacheCollectionRegion)super.buildCollectionRegion(regionName, properties, cacheDataDescription);
        return new CollectionRegionWrapper(ehcacheCollectionRegion);
    }

    public EntityRegion buildEntityRegion(String regionName, Properties properties, CacheDataDescription cacheDataDescription) throws CacheException {
        this.configureCache(regionName);
        EhcacheEntityRegion ehcacheEntityRegion = (EhcacheEntityRegion)super.buildEntityRegion(regionName, properties, cacheDataDescription);
        return new EntityRegionWrapper(ehcacheEntityRegion);
    }

    public QueryResultsRegion buildQueryResultsRegion(String regionName, Properties properties) throws CacheException {
        this.configureCache(regionName);
        EhcacheQueryResultsRegion ehcacheQueryResultsRegion = (EhcacheQueryResultsRegion)super.buildQueryResultsRegion(regionName, properties);
        return new QueryResultsRegionWrapper(ehcacheQueryResultsRegion);
    }

    public TimestampsRegion buildTimestampsRegion(String regionName, Properties properties) throws CacheException {
        this.configureCache(regionName);
        EhcacheTimestampsRegion ehcacheTimestampsRegion = (EhcacheTimestampsRegion)super.buildTimestampsRegion(regionName, properties);
        TimestampsRegionWrapper timestampsRegion = new TimestampsRegionWrapper(ehcacheTimestampsRegion);
        return timestampsRegion;
    }

    public CacheManager getCacheManager() {
        return this.manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconfigureCaches(URL cacheConfigFile) {
        CacheManager cacheManager = this.manager;
        synchronized (cacheManager) {
            Configuration configuration = EhcacheConfigurationUtil.getConfiguration(cacheConfigFile, true, this._usingDefault);
            Map cacheConfigurations = configuration.getCacheConfigurations();
            for (CacheConfiguration cacheConfiguration : cacheConfigurations.values()) {
                Cache ehcache = new Cache(cacheConfiguration);
                this.reconfigureCache((Ehcache)ehcache);
            }
        }
    }

    public void start(Settings settings, Properties properties) throws CacheException {
        try {
            String configurationPath = null;
            if (properties != null) {
                configurationPath = (String)properties.get("net.sf.ehcache.configurationResourceName");
            }
            if (Validator.isNull(configurationPath)) {
                configurationPath = _DEFAULT_CLUSTERED_EHCACHE_CONFIG_FILE;
            }
            Configuration configuration = null;
            if (Validator.isNull((String)configurationPath)) {
                configuration = ConfigurationFactory.parseConfiguration();
            } else {
                this._usingDefault = configurationPath.equals(_DEFAULT_CLUSTERED_EHCACHE_CONFIG_FILE);
                configuration = EhcacheConfigurationUtil.getConfiguration(configurationPath, true, this._usingDefault);
            }
            this.manager = new CacheManager(configuration);
            FailSafeTimer failSafeTimer = this.manager.getTimer();
            failSafeTimer.cancel();
            try {
                Field cacheManagerTimerField = ReflectionUtil.getDeclaredField(CacheManager.class, (String)"cacheManagerTimer");
                cacheManagerTimerField.set(this.manager, null);
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
            this.mbeanRegistrationHelper.registerMBean(this.manager, properties);
            this._mBeanRegisteringPortalLifecycle = new MBeanRegisteringPortalLifecycle(this.manager);
            this._mBeanRegisteringPortalLifecycle.registerPortalLifecycle(2);
        }
        catch (net.sf.ehcache.CacheException ce) {
            throw new CacheException((Throwable)ce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configureCache(String regionName) {
        CacheManager cacheManager = this.manager;
        synchronized (cacheManager) {
            Ehcache ehcache = this.manager.getEhcache(regionName);
            if (ehcache == null) {
                this.manager.addCache(regionName);
                ehcache = this.manager.getEhcache(regionName);
            }
            if (!(ehcache instanceof ModifiableEhcacheWrapper)) {
                ModifiableEhcacheWrapper modifiableEhcacheWrapper = new ModifiableEhcacheWrapper(ehcache);
                this.manager.replaceCacheWithDecoratedCache(ehcache, (Ehcache)modifiableEhcacheWrapper);
            }
        }
    }

    protected void reconfigureCache(Ehcache replacementCache) {
        String cacheName = replacementCache.getName();
        Ehcache ehcache = this.manager.getEhcache(cacheName);
        if (ehcache != null && ehcache instanceof ModifiableEhcacheWrapper) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Reconfiguring Hibernate cache " + cacheName));
            }
            ModifiableEhcacheWrapper modifiableEhcacheWrapper = (ModifiableEhcacheWrapper)ehcache;
            this.manager.replaceCacheWithDecoratedCache(ehcache, modifiableEhcacheWrapper.getWrappedCache());
            this.manager.removeCache(cacheName);
            this.manager.addCache(replacementCache);
            modifiableEhcacheWrapper.setWrappedCache(replacementCache);
            this.manager.replaceCacheWithDecoratedCache(replacementCache, (Ehcache)modifiableEhcacheWrapper);
        } else {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Configuring Hibernate cache " + cacheName));
            }
            if (ehcache != null) {
                this.manager.removeCache(cacheName);
            }
            ehcache = new ModifiableEhcacheWrapper(replacementCache);
            this.manager.addCache(replacementCache);
            this.manager.replaceCacheWithDecoratedCache(replacementCache, ehcache);
        }
    }
}

