/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.shard;

import com.liferay.portal.dao.shard.ShardDataSourceTargetSource;
import com.liferay.portal.dao.shard.advice.ShardAdvice;
import com.liferay.portal.kernel.dao.shard.Shard;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.util.PropsValues;
import javax.sql.DataSource;

public class ShardImpl
implements Shard {
    private static ShardAdvice _shardAdvice;

    public String[] getAvailableShardNames() {
        ShardDataSourceTargetSource shardDataSourceTargetSource = (ShardDataSourceTargetSource)InfrastructureUtil.getShardDataSourceTargetSource();
        if (shardDataSourceTargetSource != null) {
            return shardDataSourceTargetSource.getAvailableShardNames();
        }
        return null;
    }

    public String getCurrentShardName() {
        return _shardAdvice.getCurrentShardName();
    }

    public DataSource getDataSource() {
        return _shardAdvice.getDataSource();
    }

    public String getDefaultShardName() {
        return PropsValues.SHARD_DEFAULT_NAME;
    }

    public boolean isEnabled() {
        return _shardAdvice != null;
    }

    public String popCompanyService() {
        String value = null;
        if (_shardAdvice != null) {
            value = _shardAdvice.popCompanyService();
        }
        return value;
    }

    public void pushCompanyService(long companyId) {
        if (_shardAdvice != null) {
            _shardAdvice.pushCompanyService(companyId);
        }
    }

    public void pushCompanyService(String shardName) {
        if (_shardAdvice != null) {
            _shardAdvice.pushCompanyService(shardName);
        }
    }

    public void setShardAdvice(ShardAdvice shardAdvice) {
        _shardAdvice = shardAdvice;
    }
}

