/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.shard;

import com.liferay.portal.dao.shard.ShardDataSourceTargetSource;
import com.liferay.portal.spring.hibernate.PortalHibernateConfiguration;
import com.liferay.portal.util.PropsValues;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.hibernate.SessionFactory;
import org.springframework.aop.TargetSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShardSessionFactoryTargetSource
implements TargetSource {
    private static Map<String, SessionFactory> _sessionFactories = new HashMap<String, SessionFactory>();
    private static ThreadLocal<SessionFactory> _sessionFactory = new ThreadLocal<SessionFactory>(){

        @Override
        protected SessionFactory initialValue() {
            return (SessionFactory)_sessionFactories.get(PropsValues.SHARD_DEFAULT_NAME);
        }
    };

    public Map<String, SessionFactory> getSessionFactories() {
        return _sessionFactories;
    }

    public SessionFactory getSessionFactory() {
        return _sessionFactory.get();
    }

    public Object getTarget() throws Exception {
        return this.getSessionFactory();
    }

    public Class<?> getTargetClass() {
        return _sessionFactories.get(PropsValues.SHARD_DEFAULT_NAME).getClass();
    }

    public boolean isStatic() {
        return false;
    }

    public void releaseTarget(Object target) throws Exception {
    }

    public void setSessionFactory(String shardName) {
        _sessionFactory.set(_sessionFactories.get(shardName));
    }

    public void setShardDataSourceTargetSource(ShardDataSourceTargetSource shardDataSourceTargetSource) throws Exception {
        Map<String, DataSource> dataSources = shardDataSourceTargetSource.getDataSources();
        for (String shardName : dataSources.keySet()) {
            DataSource dataSource = dataSources.get(shardName);
            PortalHibernateConfiguration portalHibernateConfiguration = new PortalHibernateConfiguration();
            portalHibernateConfiguration.setDataSource(dataSource);
            SessionFactory sessionFactory = portalHibernateConfiguration.buildSessionFactory();
            _sessionFactories.put(shardName, sessionFactory);
        }
    }
}

