/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.shard.advice;

import com.liferay.portal.dao.shard.ShardDataSourceTargetSource;
import com.liferay.portal.dao.shard.ShardSessionFactoryTargetSource;
import com.liferay.portal.dao.shard.advice.ShardAdvice;
import com.liferay.portal.kernel.dao.shard.ShardUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class ShardGloballyAdvice
implements MethodInterceptor {
    private static Log _log = LogFactoryUtil.getLog(ShardGloballyAdvice.class);
    private ShardAdvice _shardAdvice;

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        this._shardAdvice.setGlobalCall(new Object());
        try {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("All shards invoked for " + methodInvocation.toString()));
            }
            String[] stringArray = ShardUtil.getAvailableShardNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String shardName = stringArray[n2];
                ShardDataSourceTargetSource dataSourceTargetSource = this._shardAdvice.getShardDataSourceTargetSource();
                dataSourceTargetSource.setDataSource(shardName);
                ShardSessionFactoryTargetSource shardSessionFactoryTargetSource = this._shardAdvice.getShardSessionFactoryTargetSource();
                shardSessionFactoryTargetSource.setSessionFactory(shardName);
                methodInvocation.proceed();
                ++n2;
            }
        }
        finally {
            this._shardAdvice.setGlobalCall(null);
        }
        return null;
    }

    public void setShardAdvice(ShardAdvice shardAdvice) {
        this._shardAdvice = shardAdvice;
    }
}

