/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.shard.advice;

import com.liferay.portal.dao.shard.advice.ShardAdvice;
import com.liferay.portal.kernel.dao.shard.ShardUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class ShardIterativelyAdvice
implements MethodInterceptor {
    private static Log _log = LogFactoryUtil.getLog(ShardIterativelyAdvice.class);
    private ShardAdvice _shardAdvice;

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Iterating through all shards for " + methodInvocation.toString()));
        }
        String[] stringArray = ShardUtil.getAvailableShardNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String shardName = stringArray[n2];
            this._shardAdvice.pushCompanyService(shardName);
            try {
                methodInvocation.proceed();
            }
            finally {
                this._shardAdvice.popCompanyService();
            }
            ++n2;
        }
        return null;
    }

    public void setShardAdvice(ShardAdvice shardAdvice) {
        this._shardAdvice = shardAdvice;
    }
}

