/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy;

import com.liferay.portal.deploy.DeployUtil;
import com.liferay.portal.events.GlobalStartupAction;
import com.liferay.portal.kernel.deploy.DeployManager;
import com.liferay.portal.kernel.deploy.auto.AutoDeployListener;
import com.liferay.portal.kernel.deploy.auto.context.AutoDeploymentContext;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.plugin.PluginPackageUtil;
import java.io.File;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployManagerImpl
implements DeployManager {
    public void deploy(AutoDeploymentContext autoDeploymentContext) throws Exception {
        List<AutoDeployListener> autoDeployListeners = GlobalStartupAction.getAutoDeployListeners();
        for (AutoDeployListener autoDeployListener : autoDeployListeners) {
            autoDeployListener.deploy(autoDeploymentContext);
        }
    }

    public String getDeployDir() throws Exception {
        return DeployUtil.getAutoDeployDestDir();
    }

    public String getInstalledDir() throws Exception {
        if (ServerDetector.isGlassfish()) {
            File file = new File(System.getProperty("com.sun.aas.instanceRoot"), "autodeploy");
            return file.getAbsolutePath();
        }
        return DeployUtil.getAutoDeployDestDir();
    }

    public PluginPackage getInstalledPluginPackage(String context) {
        return PluginPackageUtil.getInstalledPluginPackage(context);
    }

    public List<PluginPackage> getInstalledPluginPackages() {
        return PluginPackageUtil.getInstalledPluginPackages();
    }

    public boolean isDeployed(String context) {
        return PluginPackageUtil.isInstalled(context);
    }

    public PluginPackage readPluginPackageProperties(String displayName, Properties properties) {
        return PluginPackageUtil.readPluginPackageProperties(displayName, properties);
    }

    public PluginPackage readPluginPackageXml(String xml) throws Exception {
        return PluginPackageUtil.readPluginPackageXml(xml);
    }

    public void redeploy(String context) throws Exception {
        if (ServerDetector.isJetty()) {
            DeployUtil.redeployJetty(context);
        } else if (ServerDetector.isTomcat()) {
            DeployUtil.redeployTomcat(context);
        }
    }

    public void undeploy(String context) throws Exception {
        File deployDir = new File(this.getDeployDir(), context);
        if (!deployDir.exists()) {
            deployDir = new File(this.getDeployDir(), String.valueOf(context) + ".war");
        }
        DeployUtil.undeploy(ServerDetector.getServerId(), deployDir);
    }
}

