/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.ant.CopyTask;
import com.liferay.util.ant.DeleteTask;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployUtil {
    private static Log _log = LogFactoryUtil.getLog(DeployUtil.class);
    private static DeployUtil _instance = new DeployUtil();

    public static void copyDependencyXml(String fileName, String targetDir, String targetFileName, Map<String, String> filterMap, boolean overwrite) throws Exception {
        File file = new File(DeployUtil.getResourcePath(fileName));
        File targetFile = new File(targetDir, targetFileName);
        if (!targetFile.exists()) {
            CopyTask.copyFile((File)file, (File)new File(targetDir), (String)targetFileName, filterMap, (boolean)overwrite, (boolean)true);
        }
    }

    public static String getAutoDeployDestDir() throws Exception {
        String destDir = PrefsPropsUtil.getString("auto.deploy.dest.dir", PropsValues.AUTO_DEPLOY_DEST_DIR);
        if (Validator.isNull((String)destDir)) {
            destDir = DeployUtil.getAutoDeployServerDestDir();
        }
        return destDir;
    }

    public static String getAutoDeployServerDestDir() throws Exception {
        String destDir = null;
        String serverId = GetterUtil.getString((String)ServerDetector.getServerId());
        destDir = serverId.equals("tomcat") ? PrefsPropsUtil.getString("auto.deploy.tomcat.dest.dir", PropsValues.AUTO_DEPLOY_TOMCAT_DEST_DIR) : PrefsPropsUtil.getString("auto.deploy." + serverId + ".dest.dir");
        if (Validator.isNull((String)destDir)) {
            destDir = PrefsPropsUtil.getString("auto.deploy.default.dest.dir", PropsValues.AUTO_DEPLOY_DEFAULT_DEST_DIR);
        }
        destDir = StringUtil.replace((String)destDir, (char)'\\', (char)'/');
        return destDir;
    }

    public static String getResourcePath(String resource) throws Exception {
        return _instance._getResourcePath(resource);
    }

    public static void redeployJetty(String context) throws Exception {
        String contextsDirName = String.valueOf(System.getProperty("jetty.home")) + "/contexts";
        File contextXml = new File(String.valueOf(contextsDirName) + "/" + context + ".xml");
        if (contextXml.exists()) {
            FileUtils.touch((File)contextXml);
        } else {
            HashMap<String, String> filterMap = new HashMap<String, String>();
            filterMap.put("context", context);
            DeployUtil.copyDependencyXml("jetty-context-configure.xml", contextsDirName, String.valueOf(context) + ".xml", filterMap, true);
        }
    }

    public static void redeployTomcat(String context) throws Exception {
        File webXml = new File(DeployUtil.getAutoDeployDestDir(), "/WEB-INF/web.xml");
        FileUtils.touch((File)webXml);
    }

    public static void undeploy(String appServerType, File deployDir) throws Exception {
        boolean undeployEnabled = PrefsPropsUtil.getBoolean("hot.undeploy.enabled", PropsValues.HOT_UNDEPLOY_ENABLED);
        if (!undeployEnabled) {
            return;
        }
        if (!(appServerType.equals("glassfish") || appServerType.equals("jboss") || appServerType.equals("jetty") || appServerType.equals("tomcat") || appServerType.equals("weblogic"))) {
            return;
        }
        if (!deployDir.exists()) {
            return;
        }
        if (deployDir.isFile()) {
            FileUtil.delete((File)deployDir);
        } else {
            File webXml = new File(deployDir + "/WEB-INF/web.xml");
            if (!webXml.exists()) {
                return;
            }
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Undeploy " + deployDir));
            }
            FileUtil.delete((String)(deployDir + "/WEB-INF/web.xml"));
            DeleteTask.deleteDirectory((File)deployDir);
        }
        if (appServerType.equals("jetty")) {
            FileUtil.delete((String)(String.valueOf(System.getProperty("jetty.home")) + "/contexts/" + deployDir.getName() + ".xml"));
        }
        if (appServerType.equals("jboss")) {
            File deployedFile = new File(deployDir.getParent(), String.valueOf(deployDir.getName()) + ".deployed");
            FileUtil.delete((File)deployedFile);
        }
        int undeployInterval = PrefsPropsUtil.getInteger("hot.undeploy.interval", PropsValues.HOT_UNDEPLOY_INTERVAL);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Wait " + undeployInterval + " ms to allow the plugin time to fully undeploy"));
        }
        if (undeployInterval > 0) {
            Thread.sleep(undeployInterval);
        }
    }

    private DeployUtil() {
    }

    private String _getResourcePath(String resource) throws IOException {
        InputStream is = this.getClass().getResourceAsStream("dependencies/" + resource);
        if (is == null) {
            return null;
        }
        String tmpDir = SystemProperties.get((String)"java.io.tmpdir");
        File file = new File(String.valueOf(tmpDir) + "/liferay/com/liferay/portal/deploy/dependencies/" + resource);
        File parentFile = file.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        StreamUtil.transfer((InputStream)is, (OutputStream)new FileOutputStream(file));
        return FileUtil.getAbsolutePath((File)file);
    }
}

