/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.auto;

import com.liferay.portal.deploy.auto.AutoDeployer;
import com.liferay.portal.kernel.deploy.auto.AutoDeployException;
import com.liferay.portal.kernel.deploy.auto.context.AutoDeploymentContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class LiferayPackageAutoDeployer
implements AutoDeployer {
    protected String baseDir;
    private static Log _log = LogFactoryUtil.getLog(LiferayPackageAutoDeployer.class);

    public LiferayPackageAutoDeployer() {
        try {
            this.baseDir = PrefsPropsUtil.getString("auto.deploy.deploy.dir", PropsValues.AUTO_DEPLOY_DEPLOY_DIR);
        }
        catch (Exception e2) {
            _log.error((Throwable)e2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int autoDeploy(AutoDeploymentContext autoDeploymentContext) throws AutoDeployException {
        ZipFile zipFile;
        block16: {
            zipFile = null;
            try {
                InputStream inputStream;
                File file = autoDeploymentContext.getFile();
                zipFile = new ZipFile(file);
                ArrayList<String> fileNames = new ArrayList<String>(zipFile.size());
                String propertiesString = null;
                Enumeration<? extends ZipEntry> enu = zipFile.entries();
                while (true) {
                    if (!enu.hasMoreElements()) {
                        if (propertiesString != null) {
                            Message message = new Message();
                            message.put("command", (Object)"deploy");
                            message.put("fileNames", fileNames);
                            message.put("properties", propertiesString);
                            MessageBusUtil.sendMessage((String)"liferay/marketplace", (Message)message);
                        }
                        if (zipFile == null) return 1;
                        break block16;
                    }
                    ZipEntry zipEntry = enu.nextElement();
                    String zipEntryFileName = zipEntry.getName();
                    if (!zipEntryFileName.endsWith(".war") && !zipEntryFileName.endsWith(".xml") && !zipEntryFileName.endsWith(".zip") && !zipEntryFileName.equals("liferay-marketplace.properties")) continue;
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Extracting " + zipEntryFileName + " from " + file.getName()));
                    }
                    inputStream = null;
                    inputStream = zipFile.getInputStream(zipEntry);
                    if (zipEntryFileName.equals("liferay-marketplace.properties")) {
                        inputStream = zipFile.getInputStream(zipEntry);
                        propertiesString = StringUtil.read((InputStream)inputStream);
                        continue;
                    }
                    fileNames.add(zipEntryFileName);
                    FileUtil.write((String)(String.valueOf(this.baseDir) + "/" + zipEntryFileName), (InputStream)inputStream);
                    continue;
                    break;
                }
                finally {
                    StreamUtil.cleanUp((InputStream)inputStream);
                }
            }
            catch (Exception e2) {
                try {
                    throw new AutoDeployException((Throwable)e2);
                }
                catch (Throwable throwable) {
                    if (zipFile == null) throw throwable;
                    try {
                        zipFile.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
        }
        try {
            zipFile.close();
            return 1;
        }
        catch (IOException iOException) {}
        return 1;
    }
}

