/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.hot;

import com.liferay.portal.apache.bridges.struts.LiferayServletContextProvider;
import com.liferay.portal.kernel.atom.AtomCollectionAdapterRegistryUtil;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.kernel.deploy.hot.BaseHotDeployListener;
import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployException;
import com.liferay.portal.kernel.javadoc.JavadocManagerUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.scheduler.SchedulerEngineUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.servlet.DirectServletRegistryUtil;
import com.liferay.portal.kernel.servlet.FileTimestampUtil;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webdav.WebDAVStorage;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.model.PortletApp;
import com.liferay.portal.model.PortletCategory;
import com.liferay.portal.model.PortletURLListener;
import com.liferay.portal.poller.PollerProcessorUtil;
import com.liferay.portal.pop.POPServerUtil;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.ResourceActionLocalServiceUtil;
import com.liferay.portal.service.ResourceCodeLocalServiceUtil;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.WebAppPool;
import com.liferay.portal.xmlrpc.XmlRpcServlet;
import com.liferay.portlet.CustomUserAttributes;
import com.liferay.portlet.InvokerPortlet;
import com.liferay.portlet.PortletBagFactory;
import com.liferay.portlet.PortletContextBag;
import com.liferay.portlet.PortletContextBagPool;
import com.liferay.portlet.PortletFilterFactory;
import com.liferay.portlet.PortletInstanceFactoryUtil;
import com.liferay.portlet.PortletResourceBundles;
import com.liferay.portlet.PortletURLListenerFactory;
import com.liferay.portlet.asset.AssetRendererFactoryRegistryUtil;
import com.liferay.portlet.social.model.SocialActivityInterpreter;
import com.liferay.portlet.social.model.SocialRequestInterpreter;
import com.liferay.portlet.social.service.SocialActivityInterpreterLocalServiceUtil;
import com.liferay.portlet.social.service.SocialRequestInterpreterLocalServiceUtil;
import com.liferay.util.bridges.php.PHPPortlet;
import com.liferay.util.log4j.Log4JUtil;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.portlet.Portlet;
import javax.portlet.PortletURLGenerationListener;
import javax.portlet.filter.ActionFilter;
import javax.portlet.filter.EventFilter;
import javax.portlet.filter.PortletFilter;
import javax.portlet.filter.RenderFilter;
import javax.portlet.filter.ResourceFilter;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import org.apache.portals.bridges.struts.StrutsPortlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletHotDeployListener
extends BaseHotDeployListener {
    private static final String _JNDI_JDBC = "java_liferay:jdbc";
    private static final String _JNDI_JDBC_LIFERAY_POOL = "java_liferay:jdbc/LiferayPool";
    private static Log _log = LogFactoryUtil.getLog(PortletHotDeployListener.class);
    private static Map<String, Boolean> _dataSourceBindStates = new HashMap<String, Boolean>();
    private static Map<String, ObjectValuePair<long[], List<com.liferay.portal.model.Portlet>>> _portlets = new HashMap<String, ObjectValuePair<long[], List<com.liferay.portal.model.Portlet>>>();

    public void invokeDeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeDeploy(hotDeployEvent);
        }
        catch (Throwable t) {
            this.throwHotDeployException(hotDeployEvent, "Error registering portlets for ", t);
        }
    }

    public void invokeUndeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeUndeploy(hotDeployEvent);
        }
        catch (Throwable t) {
            this.throwHotDeployException(hotDeployEvent, "Error unregistering portlets for ", t);
        }
    }

    protected void bindDataSource(String servletContextName) throws Exception {
        block10: {
            DataSource dataSource;
            if (ServerDetector.isGlassfish() || ServerDetector.isJOnAS()) {
                return;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Dynamically binding the Liferay data source");
            }
            if ((dataSource = InfrastructureUtil.getDataSource()) == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Abort dynamically binding the Liferay data source because it is not available");
                }
                return;
            }
            InitialContext context = new InitialContext();
            try {
                try {
                    context.lookup(_JNDI_JDBC);
                }
                catch (NamingException namingException) {
                    context.createSubcontext(_JNDI_JDBC);
                }
                try {
                    context.lookup(_JNDI_JDBC_LIFERAY_POOL);
                }
                catch (NamingException namingException) {
                    context.bind(_JNDI_JDBC_LIFERAY_POOL, (Object)dataSource);
                }
                _dataSourceBindStates.put(servletContextName, true);
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block10;
                _log.warn((Object)("Unable to dynamically bind the Liferay data source: " + e2.getMessage()));
            }
        }
    }

    protected void destroyPortlet(com.liferay.portal.model.Portlet portlet, Set<String> portletIds) throws Exception {
        List workflowHandlers;
        List atomCollectionAdapters;
        List schedulerEntries;
        PortletApp portletApp = portlet.getPortletApp();
        Set portletFilters = portletApp.getPortletFilters();
        for (com.liferay.portal.model.PortletFilter portletFilter : portletFilters) {
            PortletFilterFactory.destroy(portletFilter);
        }
        Set portletURLListeners = portletApp.getPortletURLListeners();
        for (PortletURLListener portletURLListener : portletURLListeners) {
            PortletURLListenerFactory.destroy(portletURLListener);
        }
        List indexers = portlet.getIndexerInstances();
        for (Indexer indexer : indexers) {
            IndexerRegistryUtil.unregister((Indexer)indexer);
        }
        if (PropsValues.SCHEDULER_ENABLED && (schedulerEntries = portlet.getSchedulerEntries()) != null && !schedulerEntries.isEmpty()) {
            for (SchedulerEntry schedulerEntry : schedulerEntries) {
                SchedulerEngineUtil.unschedule((SchedulerEntry)schedulerEntry, (StorageType)StorageType.MEMORY_CLUSTERED);
            }
        }
        PollerProcessorUtil.deletePollerProcessor(portlet.getPortletId());
        POPServerUtil.deleteListener(portlet.getPopMessageListenerInstance());
        SocialActivityInterpreterLocalServiceUtil.deleteActivityInterpreter((SocialActivityInterpreter)portlet.getSocialActivityInterpreterInstance());
        SocialRequestInterpreterLocalServiceUtil.deleteRequestInterpreter((SocialRequestInterpreter)portlet.getSocialRequestInterpreterInstance());
        WebDAVUtil.deleteStorage((WebDAVStorage)portlet.getWebDAVStorageInstance());
        XmlRpcServlet.unregisterMethod(portlet.getXmlRpcMethodInstance());
        List assetRendererFactories = portlet.getAssetRendererFactoryInstances();
        if (assetRendererFactories != null) {
            AssetRendererFactoryRegistryUtil.unregister((List)assetRendererFactories);
        }
        if ((atomCollectionAdapters = portlet.getAtomCollectionAdapterInstances()) != null) {
            AtomCollectionAdapterRegistryUtil.unregister((List)atomCollectionAdapters);
        }
        if ((workflowHandlers = portlet.getWorkflowHandlerInstances()) != null) {
            WorkflowHandlerRegistryUtil.unregister((List)workflowHandlers);
        }
        PortletInstanceFactoryUtil.destroy((com.liferay.portal.model.Portlet)portlet);
        portletIds.add(portlet.getPortletId());
    }

    protected void doInvokeDeploy(HotDeployEvent hotDeployEvent) throws Exception {
        long[] companyIds;
        String[] xmls;
        ServletContext servletContext = hotDeployEvent.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking deploy for " + servletContextName));
        }
        if ((xmls = new String[]{HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/portlet.xml")), HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/portlet-custom.xml")), HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/liferay-portlet.xml")), HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/web.xml"))})[0] == null && xmls[1] == null) {
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Registering portlets for " + servletContextName));
        }
        List portlets = PortletLocalServiceUtil.initWAR((String)servletContextName, (ServletContext)servletContext, (String[])xmls, (PluginPackage)hotDeployEvent.getPluginPackage());
        ClassLoader classLoader = hotDeployEvent.getContextClassLoader();
        this.initLogger(classLoader);
        boolean portletAppInitialized = false;
        boolean phpPortlet = false;
        boolean strutsBridges = false;
        PortletBagFactory portletBagFactory = new PortletBagFactory();
        portletBagFactory.setClassLoader(classLoader);
        portletBagFactory.setServletContext(servletContext);
        portletBagFactory.setWARFile(true);
        Iterator itr = portlets.iterator();
        while (itr.hasNext()) {
            Portlet portletInstance;
            com.liferay.portal.model.Portlet portlet = (com.liferay.portal.model.Portlet)itr.next();
            PortletBag portletBag = this.initPortlet(portlet, portletBagFactory);
            if (portletBag == null) {
                itr.remove();
                continue;
            }
            if (!portletAppInitialized) {
                this.initPortletApp(servletContextName, servletContext, classLoader, portlet);
                portletAppInitialized = true;
            }
            if (ClassUtil.isSubclass((portletInstance = portletBag.getPortletInstance()).getClass(), (String)PHPPortlet.class.getName())) {
                phpPortlet = true;
            }
            if (!ClassUtil.isSubclass(portletInstance.getClass(), (String)StrutsPortlet.class.getName())) continue;
            strutsBridges = true;
        }
        if (phpPortlet) {
            this.bindDataSource(servletContextName);
        }
        if (!strutsBridges) {
            strutsBridges = GetterUtil.getBoolean((String)servletContext.getInitParameter("struts-bridges-context-provider"));
        }
        if (strutsBridges) {
            servletContext.setAttribute("STRUTS_BRIDGES_CONTEXT_PROVIDER", (Object)new LiferayServletContextProvider());
        }
        String xml = HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/liferay-display.xml"));
        PortletCategory newPortletCategory = PortletLocalServiceUtil.getWARDisplay((String)servletContextName, (String)xml);
        long[] lArray = companyIds = PortalInstances.getCompanyIds();
        int n = companyIds.length;
        int n2 = 0;
        while (n2 < n) {
            long companyId = lArray[n2];
            PortletCategory portletCategory = (PortletCategory)WebAppPool.get(companyId, "PORTLET_CATEGORY");
            if (portletCategory != null) {
                portletCategory.merge(newPortletCategory);
            } else {
                _log.error((Object)("Unable to register portlet for company " + companyId + " because it does not exist"));
            }
            ++n2;
        }
        this.processPortletProperties(servletContextName, classLoader);
        for (com.liferay.portal.model.Portlet portlet : portlets) {
            List modelNames = ResourceActionsUtil.getPortletModelResources((String)portlet.getPortletId());
            long[] lArray2 = companyIds;
            int n3 = companyIds.length;
            int n4 = 0;
            while (n4 < n3) {
                long companyId = lArray2[n4];
                ResourceCodeLocalServiceUtil.checkResourceCodes((long)companyId, (String)portlet.getPortletId());
                for (String modelName : modelNames) {
                    ResourceCodeLocalServiceUtil.checkResourceCodes((long)companyId, (String)modelName);
                }
                ++n4;
            }
            List portletActions = ResourceActionsUtil.getPortletResourceActions((String)portlet.getPortletId());
            ResourceActionLocalServiceUtil.checkResourceActions((String)portlet.getPortletId(), (List)portletActions);
            for (String modelName : modelNames) {
                List modelActions = ResourceActionsUtil.getModelResourceActions((String)modelName);
                ResourceActionLocalServiceUtil.checkResourceActions((String)modelName, (List)modelActions);
            }
            long[] lArray3 = companyIds;
            int n5 = companyIds.length;
            n3 = 0;
            while (n3 < n5) {
                long companyId = lArray3[n3];
                com.liferay.portal.model.Portlet curPortlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)portlet.getPortletId());
                PortletLocalServiceUtil.checkPortlet((com.liferay.portal.model.Portlet)curPortlet);
                ++n3;
            }
        }
        for (com.liferay.portal.model.Portlet portlet : portlets) {
            boolean ready = GetterUtil.getBoolean((String)servletContext.getInitParameter("portlets-ready-by-default"), (boolean)true);
            portlet.setReady(ready);
        }
        this.registerClpMessageListeners(servletContext, classLoader);
        JavadocManagerUtil.load((String)servletContextName, (ClassLoader)classLoader);
        DirectServletRegistryUtil.clearServlets();
        FileTimestampUtil.reset();
        _portlets.put(servletContextName, (ObjectValuePair<long[], List<com.liferay.portal.model.Portlet>>)new ObjectValuePair((Object)companyIds, (Object)portlets));
        if (_log.isInfoEnabled()) {
            if (portlets.size() == 1) {
                _log.info((Object)("1 portlet for " + servletContextName + " is available for use"));
            } else {
                _log.info((Object)(String.valueOf(portlets.size()) + " portlets for " + servletContextName + " are available for use"));
            }
        }
    }

    protected void doInvokeUndeploy(HotDeployEvent hotDeployEvent) throws Exception {
        ObjectValuePair<long[], List<com.liferay.portal.model.Portlet>> ovp;
        ServletContext servletContext = hotDeployEvent.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking undeploy for " + servletContextName));
        }
        if ((ovp = _portlets.remove(servletContextName)) == null) {
            return;
        }
        long[] companyIds = (long[])ovp.getKey();
        List portlets = (List)ovp.getValue();
        HashSet<String> portletIds = new HashSet<String>();
        if (portlets != null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Unregistering portlets for " + servletContextName));
            }
            for (com.liferay.portal.model.Portlet portlet : portlets) {
                this.destroyPortlet(portlet, portletIds);
            }
        }
        ServletContextPool.remove((String)servletContextName);
        if (portletIds.size() > 0) {
            long[] lArray = companyIds;
            int n = companyIds.length;
            int n2 = 0;
            while (n2 < n) {
                long companyId = lArray[n2];
                PortletCategory portletCategory = (PortletCategory)WebAppPool.get(companyId, "PORTLET_CATEGORY");
                portletCategory.separate(portletIds);
                ++n2;
            }
        }
        PortletContextBagPool.remove(servletContextName);
        PortletResourceBundles.remove(servletContextName);
        this.unbindDataSource(servletContextName);
        this.unregisterClpMessageListeners(servletContext);
        JavadocManagerUtil.unload((String)servletContextName);
        DirectServletRegistryUtil.clearServlets();
        FileTimestampUtil.reset();
        if (_log.isInfoEnabled()) {
            if (portlets.size() == 1) {
                _log.info((Object)("1 portlet for " + servletContextName + " was unregistered"));
            } else {
                _log.info((Object)(String.valueOf(portlets.size()) + " portlets for " + servletContextName + " was unregistered"));
            }
        }
    }

    protected void initLogger(ClassLoader classLoader) {
        Log4JUtil.configureLog4J((URL)classLoader.getResource("META-INF/portal-log4j.xml"));
    }

    protected PortletBag initPortlet(com.liferay.portal.model.Portlet portlet, PortletBagFactory portletBagFactory) throws Exception {
        return portletBagFactory.create(portlet);
    }

    protected void initPortletApp(String servletContextName, ServletContext servletContext, ClassLoader classLoader, com.liferay.portal.model.Portlet portlet) throws Exception {
        PortletContextBag portletContextBag = new PortletContextBag(servletContextName);
        PortletContextBagPool.put(servletContextName, portletContextBag);
        PortletApp portletApp = portlet.getPortletApp();
        servletContext.setAttribute("com.liferay.portal.model.PortletApp", (Object)portletApp);
        Map customUserAttributes = portletApp.getCustomUserAttributes();
        for (Map.Entry entry : customUserAttributes.entrySet()) {
            String attrCustomClass = (String)entry.getValue();
            CustomUserAttributes customUserAttributesInstance = (CustomUserAttributes)classLoader.loadClass(attrCustomClass).newInstance();
            portletContextBag.getCustomUserAttributes().put(attrCustomClass, customUserAttributesInstance);
        }
        Set portletFilters = portletApp.getPortletFilters();
        for (com.liferay.portal.model.PortletFilter portletFilter : portletFilters) {
            PortletFilter portletFilterInstance = (PortletFilter)this.newInstance(classLoader, new Class[]{ActionFilter.class, EventFilter.class, PortletFilter.class, RenderFilter.class, ResourceFilter.class}, portletFilter.getFilterClass());
            portletContextBag.getPortletFilters().put(portletFilter.getFilterName(), portletFilterInstance);
        }
        InvokerPortlet invokerPortlet = PortletInstanceFactoryUtil.create((com.liferay.portal.model.Portlet)portlet, (ServletContext)servletContext);
        invokerPortlet.setPortletFilters();
        Set portletURLListeners = portletApp.getPortletURLListeners();
        for (PortletURLListener portletURLListener : portletURLListeners) {
            PortletURLGenerationListener portletURLListenerInstance = (PortletURLGenerationListener)this.newInstance(classLoader, PortletURLGenerationListener.class, portletURLListener.getListenerClass());
            portletContextBag.getPortletURLListeners().put(portletURLListener.getListenerClass(), portletURLListenerInstance);
            PortletURLListenerFactory.create(portletURLListener);
        }
    }

    protected void processPortletProperties(String servletContextName, ClassLoader classLoader) throws Exception {
        int n;
        int n2;
        Object[] objectArray;
        Configuration portletPropertiesConfiguration = null;
        try {
            portletPropertiesConfiguration = ConfigurationFactoryUtil.getConfiguration((ClassLoader)classLoader, (String)"portlet");
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to read portlet.properties");
            }
            return;
        }
        Properties portletProperties = portletPropertiesConfiguration.getProperties();
        if (portletProperties.size() == 0) {
            return;
        }
        String languageBundleName = portletProperties.getProperty("language.bundle");
        if (Validator.isNotNull((String)languageBundleName)) {
            Locale[] locales = LanguageUtil.getAvailableLocales();
            objectArray = locales;
            n2 = locales.length;
            n = 0;
            while (n < n2) {
                Object locale = objectArray[n];
                ResourceBundle resourceBundle = ResourceBundle.getBundle(languageBundleName, (Locale)locale, classLoader);
                PortletResourceBundles.put(servletContextName, LocaleUtil.toLanguageId((Locale)locale), resourceBundle);
                ++n;
            }
        }
        String[] resourceActionConfigs = StringUtil.split((String)portletProperties.getProperty("resource.actions.configs"));
        objectArray = resourceActionConfigs;
        n2 = resourceActionConfigs.length;
        n = 0;
        while (n < n2) {
            Object resourceActionConfig = objectArray[n];
            ResourceActionsUtil.read((String)servletContextName, (ClassLoader)classLoader, (String)resourceActionConfig);
            ++n;
        }
    }

    protected void unbindDataSource(String servletContextName) {
        block8: {
            Boolean dataSourceBindState = _dataSourceBindStates.remove(servletContextName);
            if (dataSourceBindState == null) {
                return;
            }
            try {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Dynamically unbinding the Liferay data source");
                }
                InitialContext context = new InitialContext();
                try {
                    context.lookup(_JNDI_JDBC_LIFERAY_POOL);
                    context.unbind(_JNDI_JDBC_LIFERAY_POOL);
                }
                catch (NamingException namingException) {}
                try {
                    context.lookup(_JNDI_JDBC);
                    context.destroySubcontext(_JNDI_JDBC);
                }
                catch (NamingException namingException) {}
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block8;
                _log.warn((Object)("Unable to dynamically unbind the Liferay data source: " + e2.getMessage()));
            }
        }
    }
}

