/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.hot;

import com.liferay.portal.kernel.deploy.hot.BaseHotDeployListener;
import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;
import com.liferay.portal.kernel.deploy.hot.HotDeployException;
import com.liferay.portal.security.pacl.PACLClassLoaderUtil;
import com.liferay.portal.spring.context.PortletContextLoaderListener;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.springframework.web.context.ContextLoaderListener;

public class SpringHotDeployListener
extends BaseHotDeployListener {
    private static Map<String, ContextLoaderListener> _contextLoaderListeners = new HashMap<String, ContextLoaderListener>();

    public void invokeDeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeDeploy(hotDeployEvent);
        }
        catch (Throwable t) {
            this.throwHotDeployException(hotDeployEvent, "Error initializing Spring for ", t);
        }
    }

    public void invokeUndeploy(HotDeployEvent hotDeployEvent) throws HotDeployException {
        try {
            this.doInvokeUndeploy(hotDeployEvent);
        }
        catch (Throwable t) {
            this.throwHotDeployException(hotDeployEvent, "Error uninitializing Spring for ", t);
        }
    }

    protected void doInvokeDeploy(HotDeployEvent hotDeployEvent) throws Exception {
        ServletContext servletContext = hotDeployEvent.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        PortletContextLoaderListener contextLoaderListener = new PortletContextLoaderListener();
        ClassLoader contextClassLoader = PACLClassLoaderUtil.getContextClassLoader();
        try {
            PACLClassLoaderUtil.setContextClassLoader(PACLClassLoaderUtil.getPortalClassLoader());
            contextLoaderListener.contextInitialized(new ServletContextEvent(servletContext));
        }
        finally {
            PACLClassLoaderUtil.setContextClassLoader(contextClassLoader);
        }
        _contextLoaderListeners.put(servletContextName, contextLoaderListener);
    }

    protected void doInvokeUndeploy(HotDeployEvent hotDeployEvent) throws Exception {
        ServletContext servletContext = hotDeployEvent.getServletContext();
        String servletContextName = servletContext.getServletContextName();
        ContextLoaderListener contextLoaderListener = _contextLoaderListeners.remove(servletContextName);
        if (contextLoaderListener == null) {
            return;
        }
        ClassLoader contextClassLoader = PACLClassLoaderUtil.getContextClassLoader();
        try {
            PACLClassLoaderUtil.setContextClassLoader(PACLClassLoaderUtil.getPortalClassLoader());
            contextLoaderListener.contextDestroyed(new ServletContextEvent(servletContext));
        }
        finally {
            PACLClassLoaderUtil.setContextClassLoader(contextClassLoader);
        }
    }
}

