/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.mobile.device.Device;
import com.liferay.portal.kernel.mobile.device.DeviceDetectionUtil;
import com.liferay.portal.kernel.mobile.device.UnknownDevice;
import com.liferay.portal.kernel.mobile.device.rulegroup.ActionHandlerManagerUtil;
import com.liferay.portal.kernel.mobile.device.rulegroup.RuleGroupProcessorUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.mobiledevicerules.model.MDRRuleGroupInstance;
import com.liferay.portlet.mobiledevicerules.service.MDRActionLocalServiceUtil;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class DeviceServicePreAction
extends Action {
    private static Log _log = LogFactoryUtil.getLog(DeviceServicePreAction.class);

    public void run(HttpServletRequest request, HttpServletResponse response) {
        block9: {
            HttpSession session = request.getSession();
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
            Device device = (Device)session.getAttribute("DEVICE");
            if (device == null) {
                device = DeviceDetectionUtil.detectDevice((HttpServletRequest)request);
                session.setAttribute("DEVICE", (Object)device);
            }
            themeDisplay.setDevice(device);
            UnknownDevice unknownDevice = UnknownDevice.getInstance();
            if (device.equals(unknownDevice)) {
                return;
            }
            MDRRuleGroupInstance mdrRuleGroupInstance = null;
            try {
                mdrRuleGroupInstance = RuleGroupProcessorUtil.evaluateRuleGroups((ThemeDisplay)themeDisplay);
                if (_log.isDebugEnabled()) {
                    String logMessage = "Rule group evaluation returned rule group instance ";
                    logMessage = mdrRuleGroupInstance != null ? String.valueOf(logMessage) + mdrRuleGroupInstance.getRuleGroupInstanceId() : String.valueOf(logMessage) + "null";
                    _log.debug((Object)logMessage);
                }
            }
            catch (Exception e2) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Unable to retrieve rule group", (Throwable)e2);
                }
                return;
            }
            themeDisplay.setMDRRuleGroupInstance(mdrRuleGroupInstance);
            if (mdrRuleGroupInstance == null) {
                return;
            }
            try {
                List mdrActions = MDRActionLocalServiceUtil.getActions((long)mdrRuleGroupInstance.getRuleGroupInstanceId());
                ActionHandlerManagerUtil.applyActions((List)mdrActions, (HttpServletRequest)request, (HttpServletResponse)response);
            }
            catch (Exception e3) {
                if (!_log.isWarnEnabled()) break block9;
                _log.warn((Object)"Unable to apply device profile", (Throwable)e3);
            }
        }
    }
}

