/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.freemarker;

import com.liferay.portal.freemarker.FreeMarkerContextImpl;
import com.liferay.portal.freemarker.LiferayCacheStorage;
import com.liferay.portal.freemarker.LiferayObjectWrapper;
import com.liferay.portal.freemarker.LiferayTemplateClassResolver;
import com.liferay.portal.freemarker.LiferayTemplateLoader;
import com.liferay.portal.freemarker.PACLFreeMarkerContextImpl;
import com.liferay.portal.freemarker.StringTemplateLoader;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.freemarker.FreeMarkerContext;
import com.liferay.portal.kernel.freemarker.FreeMarkerEngine;
import com.liferay.portal.kernel.freemarker.FreeMarkerVariablesUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.lang.PortalSecurityManagerThreadLocal;
import com.liferay.portal.security.pacl.PACLClassLoaderUtil;
import com.liferay.portal.security.pacl.PACLPolicy;
import com.liferay.portal.security.pacl.PACLPolicyManager;
import com.liferay.portal.util.PropsValues;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateCache;
import freemarker.cache.TemplateLoader;
import freemarker.core.TemplateClassResolver;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FreeMarkerEngineImpl
implements FreeMarkerEngine {
    private static Log _log = LogFactoryUtil.getLog(FreeMarkerEngineImpl.class);
    private Map<ClassLoader, FreeMarkerContextImpl> _classLoaderFreeMarkerContexts = new ConcurrentHashMap<ClassLoader, FreeMarkerContextImpl>();
    private Configuration _configuration;
    private String _encoding;
    private Locale _locale;
    private FreeMarkerContextImpl _restrictedToolsContext;
    private FreeMarkerContextImpl _standardToolsContext;
    private StringTemplateLoader _stringTemplateLoader;
    private Constructor<?> _templateKeyConstructor;

    public void clearClassLoader(ClassLoader classLoader) {
        this._classLoaderFreeMarkerContexts.remove(classLoader);
    }

    public void flushTemplate(String freeMarkerTemplateId) {
        if (this._configuration == null) {
            return;
        }
        if (this._stringTemplateLoader != null) {
            this._stringTemplateLoader.removeTemplate(freeMarkerTemplateId);
        }
        PortalCache portalCache = LiferayCacheStorage.getPortalCache();
        portalCache.remove((Serializable)((Object)this._getResourceCacheKey(freeMarkerTemplateId)));
    }

    public FreeMarkerContext getWrappedClassLoaderToolsContext() {
        ClassLoader contextClassLoader = PACLClassLoaderUtil.getContextClassLoader();
        PACLPolicy threadLocalPACLPolicy = PortalSecurityManagerThreadLocal.getPACLPolicy();
        PACLPolicy contextClassLoaderPACLPolicy = PACLPolicyManager.getPACLPolicy(contextClassLoader);
        try {
            PortalSecurityManagerThreadLocal.setPACLPolicy(contextClassLoaderPACLPolicy);
            FreeMarkerContextImpl classLoaderContext = this._classLoaderFreeMarkerContexts.get(contextClassLoader);
            if (classLoaderContext == null) {
                classLoaderContext = new FreeMarkerContextImpl();
                FreeMarkerVariablesUtil.insertHelperUtilities((FreeMarkerContext)classLoaderContext, null);
                this._classLoaderFreeMarkerContexts.put(contextClassLoader, classLoaderContext);
            }
            PACLFreeMarkerContextImpl pACLFreeMarkerContextImpl = new PACLFreeMarkerContextImpl(classLoaderContext.getWrappedContext(), contextClassLoaderPACLPolicy);
            return pACLFreeMarkerContextImpl;
        }
        finally {
            PortalSecurityManagerThreadLocal.setPACLPolicy(threadLocalPACLPolicy);
        }
    }

    public FreeMarkerContext getWrappedRestrictedToolsContext() {
        return new FreeMarkerContextImpl(this._restrictedToolsContext.getWrappedContext());
    }

    public FreeMarkerContext getWrappedStandardToolsContext() {
        return new FreeMarkerContextImpl(this._standardToolsContext.getWrappedContext());
    }

    public void init() throws Exception {
        if (this._configuration != null) {
            return;
        }
        LiferayTemplateLoader liferayTemplateLoader = new LiferayTemplateLoader();
        liferayTemplateLoader.setTemplateLoaders(PropsValues.FREEMARKER_ENGINE_TEMPLATE_LOADERS);
        this._stringTemplateLoader = new StringTemplateLoader();
        MultiTemplateLoader multiTemplateLoader = new MultiTemplateLoader(new TemplateLoader[]{new ClassTemplateLoader(this.getClass(), "/"), this._stringTemplateLoader, liferayTemplateLoader});
        this._configuration = new Configuration();
        this._configuration.setDefaultEncoding("UTF-8");
        this._configuration.setLocalizedLookup(PropsValues.FREEMARKER_ENGINE_LOCALIZED_LOOKUP);
        this._configuration.setNewBuiltinClassResolver((TemplateClassResolver)new LiferayTemplateClassResolver());
        this._configuration.setObjectWrapper((ObjectWrapper)new LiferayObjectWrapper());
        this._configuration.setSetting("auto_import", PropsValues.FREEMARKER_ENGINE_MACRO_LIBRARY);
        this._configuration.setSetting("cache_storage", PropsValues.FREEMARKER_ENGINE_CACHE_STORAGE);
        this._configuration.setSetting("template_exception_handler", PropsValues.FREEMARKER_ENGINE_TEMPLATE_EXCEPTION_HANDLER);
        this._configuration.setTemplateLoader((TemplateLoader)multiTemplateLoader);
        this._configuration.setTemplateUpdateDelay(PropsValues.FREEMARKER_ENGINE_MODIFICATION_CHECK_INTERVAL);
        this._encoding = this._configuration.getEncoding(this._configuration.getLocale());
        this._locale = this._configuration.getLocale();
        this._restrictedToolsContext = new FreeMarkerContextImpl();
        FreeMarkerVariablesUtil.insertHelperUtilities((FreeMarkerContext)this._restrictedToolsContext, (String[])PropsValues.JOURNAL_TEMPLATE_FREEMARKER_RESTRICTED_VARIABLES);
        this._standardToolsContext = new FreeMarkerContextImpl();
        FreeMarkerVariablesUtil.insertHelperUtilities((FreeMarkerContext)this._standardToolsContext, null);
        ClassLoader classLoader = TemplateCache.class.getClassLoader();
        Class<?> templateKeyClass = classLoader.loadClass(TemplateCache.class.getName().concat("$TemplateKey"));
        this._templateKeyConstructor = templateKeyClass.getDeclaredConstructor(String.class, Locale.class, String.class, Boolean.TYPE);
        this._templateKeyConstructor.setAccessible(true);
    }

    public boolean mergeTemplate(String freeMarkerTemplateId, FreeMarkerContext freeMarkerContext, Writer writer) throws Exception {
        return this.mergeTemplate(freeMarkerTemplateId, null, freeMarkerContext, writer);
    }

    public boolean mergeTemplate(String freeMarkerTemplateId, String freemarkerTemplateContent, FreeMarkerContext freeMarkerContext, Writer writer) throws Exception {
        if (Validator.isNotNull((String)freemarkerTemplateContent)) {
            PortalCache portalCache = LiferayCacheStorage.getPortalCache();
            portalCache.remove((Serializable)((Object)this._getResourceCacheKey(freeMarkerTemplateId)));
            this._stringTemplateLoader.putTemplate(freeMarkerTemplateId, freemarkerTemplateContent);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Added " + freeMarkerTemplateId + " to the string based FreeMarker template repository"));
            }
        }
        FreeMarkerContextImpl freeMarkerContextImpl = (FreeMarkerContextImpl)freeMarkerContext;
        PACLPolicy threadLocalPACLPolicy = PortalSecurityManagerThreadLocal.getPACLPolicy();
        try {
            if (freeMarkerContextImpl instanceof PACLFreeMarkerContextImpl) {
                PACLFreeMarkerContextImpl paclContextImpl = (PACLFreeMarkerContextImpl)freeMarkerContextImpl;
                PortalSecurityManagerThreadLocal.setPACLPolicy(paclContextImpl.getPaclPolicy());
            }
            Template template = this._configuration.getTemplate(freeMarkerTemplateId, "UTF-8");
            template.process(freeMarkerContextImpl.getWrappedContext(), writer);
        }
        finally {
            if (freeMarkerContextImpl instanceof PACLFreeMarkerContextImpl) {
                PortalSecurityManagerThreadLocal.setPACLPolicy(threadLocalPACLPolicy);
            }
        }
        return true;
    }

    public boolean resourceExists(String resource) {
        try {
            Template template = this._configuration.getTemplate(resource);
            return template != null;
        }
        catch (IOException ioe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)ioe, (Throwable)ioe);
            }
            return false;
        }
    }

    private String _getResourceCacheKey(String freeMarkerTemplateId) {
        try {
            Object object = this._templateKeyConstructor.newInstance(freeMarkerTemplateId, this._locale, this._encoding, Boolean.TRUE);
            return object.toString();
        }
        catch (Exception e2) {
            throw new RuntimeException("Failed to build FreeMarker internal resource cache key for template id " + freeMarkerTemplateId, e2);
        }
    }
}

