/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.freemarker;

import com.liferay.portal.freemarker.FreeMarkerTemplateLoader;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portlet.journal.NoSuchTemplateException;
import com.liferay.portlet.journal.model.JournalTemplate;
import com.liferay.portlet.journal.service.JournalTemplateLocalServiceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class JournalTemplateLoader
extends FreeMarkerTemplateLoader {
    private static Log _log = LogFactoryUtil.getLog(JournalTemplateLoader.class);

    public Object findTemplateSource(String name) throws IOException {
        try {
            int pos = name.indexOf("_JOURNAL_CONTEXT_/");
            if (pos != -1) {
                int x = name.indexOf(47, pos);
                int y = name.indexOf(47, x + 1);
                int z = name.indexOf(47, y + 1);
                long companyId = GetterUtil.getLong((String)name.substring(x + 1, y));
                long groupId = GetterUtil.getLong((String)name.substring(y + 1, z));
                String templateId = name.substring(z + 1);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Loading {companyId=" + companyId + ", groupId=" + groupId + ", templateId=" + templateId + "}"));
                }
                JournalTemplate template = JournalTemplateLocalServiceUtil.getTemplate((long)groupId, (String)templateId);
                return template;
            }
        }
        catch (NoSuchTemplateException noSuchTemplateException) {
            return null;
        }
        catch (PortalException portalException) {
            throw new IOException("Template {" + name + "} not found");
        }
        catch (SystemException systemException) {
            throw new IOException("Template {" + name + "} not found");
        }
        return null;
    }

    public long getLastModified(Object templateSource) {
        if (templateSource instanceof JournalTemplate) {
            JournalTemplate template = (JournalTemplate)templateSource;
            return template.getModifiedDate().getTime();
        }
        return -1L;
    }

    public Reader getReader(Object templateSource, String encoding) throws IOException {
        if (templateSource instanceof JournalTemplate) {
            JournalTemplate template = (JournalTemplate)templateSource;
            String xsl = template.getXsl();
            return new UnsyncBufferedReader((Reader)new InputStreamReader((InputStream)new UnsyncByteArrayInputStream(xsl.getBytes()), encoding));
        }
        return null;
    }
}

