/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.freemarker;

import com.liferay.portal.kernel.util.Validator;
import freemarker.cache.TemplateLoader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class StringTemplateLoader
implements TemplateLoader {
    private Map<String, StringTemplateSource> _templates = new ConcurrentHashMap<String, StringTemplateSource>();

    public void closeTemplateSource(Object templateSource) {
    }

    public Object findTemplateSource(String name) {
        return this._templates.get(name);
    }

    public long getLastModified(Object templateSource) {
        StringTemplateSource stringTemplateSource = (StringTemplateSource)templateSource;
        return stringTemplateSource._lastModified;
    }

    public Reader getReader(Object templateSource, String encoding) {
        StringTemplateSource stringTemplateSource = (StringTemplateSource)templateSource;
        return new StringReader(stringTemplateSource._templateSource);
    }

    public void putTemplate(String name, String templateSource) {
        this.putTemplate(name, templateSource, System.currentTimeMillis());
    }

    public void putTemplate(String name, String templateSource, long lastModified) {
        this._templates.put(name, new StringTemplateSource(name, templateSource, lastModified));
    }

    public void removeTemplate(String name) {
        this._templates.remove(name);
    }

    private class StringTemplateSource {
        private long _lastModified;
        private String _name;
        private String _templateSource;

        public StringTemplateSource(String name, String templateSource, long lastModified) {
            if (name == null) {
                throw new IllegalArgumentException("Name is null");
            }
            if (templateSource == null) {
                throw new IllegalArgumentException("Template source is null");
            }
            if (lastModified < -1L) {
                throw new IllegalArgumentException("Last modified is less than -1");
            }
            this._name = name;
            this._templateSource = templateSource;
            this._lastModified = lastModified;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof StringTemplateSource)) {
                return false;
            }
            StringTemplateSource stringTemplateSource = (StringTemplateSource)obj;
            return Validator.equals((Object)this._name, (Object)stringTemplateSource._name);
        }

        public int hashCode() {
            return this._name.hashCode();
        }
    }
}

