/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.freemarker;

import com.liferay.portal.freemarker.URLTemplateLoader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.theme.ThemeLoader;
import com.liferay.portal.theme.ThemeLoaderFactory;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class ThemeLoaderTemplateLoader
extends URLTemplateLoader {
    private static Log _log = LogFactoryUtil.getLog(ThemeLoaderTemplateLoader.class);

    public URL getURL(String name) throws IOException {
        int pos = name.indexOf("_THEME_LOADER_CONTEXT_");
        if (pos != -1) {
            String ctxName = name.substring(0, pos);
            ThemeLoader themeLoader = ThemeLoaderFactory.getThemeLoader(ctxName);
            if (themeLoader != null) {
                String themesPath;
                String templateName = name.substring(pos + "_THEME_LOADER_CONTEXT_".length());
                if (templateName.startsWith(themesPath = themeLoader.getThemesPath())) {
                    name = templateName.substring(themesPath.length());
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(String.valueOf(name) + " is associated with the theme loader " + ctxName + " " + themeLoader));
                }
                File fileStorage = themeLoader.getFileStorage();
                return new File(String.valueOf(fileStorage.getPath()) + name).toURI().toURL();
            }
            _log.error((Object)(String.valueOf(name) + " is not valid because " + ctxName + " does not map to a theme loader"));
        }
        return null;
    }
}

