/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.freemarker;

import com.liferay.portal.freemarker.FreeMarkerTemplateLoader;
import com.liferay.portal.freemarker.URLTemplateSource;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;

public abstract class URLTemplateLoader
extends FreeMarkerTemplateLoader {
    public void closeTemplateSource(Object templateSource) {
        if (templateSource instanceof URLTemplateSource) {
            URLTemplateSource urlTemplateSource = (URLTemplateSource)templateSource;
            try {
                urlTemplateSource.closeStream();
            }
            catch (IOException iOException) {}
        }
    }

    public Object findTemplateSource(String name) throws IOException {
        URL url = this.getURL(name);
        if (url != null) {
            return new URLTemplateSource(url);
        }
        return null;
    }

    public long getLastModified(Object templateSource) {
        if (templateSource instanceof URLTemplateSource) {
            URLTemplateSource urlTemplateSource = (URLTemplateSource)templateSource;
            return urlTemplateSource.getLastModified();
        }
        return super.getLastModified(templateSource);
    }

    public Reader getReader(Object templateSource, String encoding) throws IOException {
        if (templateSource instanceof URLTemplateSource) {
            URLTemplateSource urlTemplateSource = (URLTemplateSource)templateSource;
            return new UnsyncBufferedReader((Reader)new InputStreamReader(urlTemplateSource.getInputStream(), encoding));
        }
        return null;
    }

    public abstract URL getURL(String var1) throws IOException;
}

