/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.im;

import JOscarLib.Core.OscarConnection;
import JOscarLib.Tool.OscarInterface;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.util.PropsUtil;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

public class ICQConnector
implements Observer {
    private static Log _log = LogFactoryUtil.getLog(ICQConnector.class);
    private static ICQConnector _instance = new ICQConnector();
    private boolean _connecting;
    private OscarConnection _icq;
    private List<KeyValuePair> _messages = new Vector<KeyValuePair>();

    public static void disconnect() {
        if (_instance != null) {
            _instance._disconnect();
        }
    }

    public static void send(String to, String msg) {
        _instance._send(to, msg);
    }

    public void update(Observable obs, Object obj) {
        this._connecting = false;
        for (KeyValuePair kvp : this._messages) {
            OscarInterface.sendMessage((OscarConnection)this._icq, (String)kvp.getKey(), (String)kvp.getValue());
        }
    }

    private ICQConnector() {
    }

    private void _connect() {
        this._connecting = true;
        String login = PropsUtil.get("icq.login");
        String password = PropsUtil.get("icq.password");
        this._icq = new OscarConnection("login.icq.com", 5190, login, password);
        this._icq.addObserver((Observer)this);
    }

    private void _disconnect() {
        try {
            if (this._icq != null) {
                this._icq.close();
            }
        }
        catch (Exception e2) {
            _log.warn((Throwable)e2);
        }
    }

    private synchronized void _send(String to, String msg) {
        if (!(this._icq != null && this._icq.isLogged() || this._connecting)) {
            this._connect();
            this._messages.add(new KeyValuePair(to, msg));
        } else {
            OscarInterface.sendMessage((OscarConnection)this._icq, (String)to, (String)msg);
        }
    }
}

