/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.image;

import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageTool;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.JavaDetector;
import com.liferay.portal.util.FileImpl;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.ImageEncoder;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.imageio.ImageIO;
import javax.media.jai.RenderedImageAdapter;
import net.jmge.gif.Gif89Encoder;

public class ImageToolImpl
implements ImageTool {
    private static Log _log = LogFactoryUtil.getLog(ImageToolImpl.class);
    private static ImageTool _instance = new ImageToolImpl();
    private static FileImpl _fileUtil = FileImpl.getInstance();

    public static ImageTool getInstance() {
        return _instance;
    }

    public BufferedImage convertImageType(BufferedImage sourceImage, int type) {
        BufferedImage targetImage = new BufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), type);
        Graphics2D graphics = targetImage.createGraphics();
        graphics.drawRenderedImage(sourceImage, null);
        graphics.dispose();
        return targetImage;
    }

    public void encodeGIF(RenderedImage renderedImage, OutputStream os) throws IOException {
        if (JavaDetector.isJDK6()) {
            ImageIO.write(renderedImage, "gif", os);
        } else {
            BufferedImage bufferedImage = this.getBufferedImage(renderedImage);
            if (!(bufferedImage.getColorModel() instanceof IndexColorModel)) {
                bufferedImage = this.convertImageType(bufferedImage, 13);
            }
            Gif89Encoder encoder = new Gif89Encoder((Image)bufferedImage);
            encoder.encode(os);
        }
    }

    public void encodeWBMP(RenderedImage renderedImage, OutputStream os) throws IOException {
        BufferedImage bufferedImage = this.getBufferedImage(renderedImage);
        SampleModel sampleModel = bufferedImage.getSampleModel();
        int type = sampleModel.getDataType();
        if (bufferedImage.getType() != 12 || type < 0 || type > 3 || sampleModel.getNumBands() != 1 || sampleModel.getSampleSize(0) != 1) {
            BufferedImage binaryImage = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 12);
            Graphics graphics = binaryImage.getGraphics();
            graphics.drawImage(bufferedImage, 0, 0, null);
            renderedImage = binaryImage;
        }
        if (!ImageIO.write(renderedImage, "wbmp", os)) {
            os.write(0);
            os.write(0);
            os.write(this._toMultiByte(bufferedImage.getWidth()));
            os.write(this._toMultiByte(bufferedImage.getHeight()));
            DataBuffer dataBuffer = bufferedImage.getData().getDataBuffer();
            int size = dataBuffer.getSize();
            int i2 = 0;
            while (i2 < size) {
                os.write((byte)dataBuffer.getElem(i2));
                ++i2;
            }
        }
    }

    public BufferedImage getBufferedImage(RenderedImage renderedImage) {
        if (renderedImage instanceof BufferedImage) {
            return (BufferedImage)renderedImage;
        }
        RenderedImageAdapter adapter = new RenderedImageAdapter(renderedImage);
        return adapter.getAsBufferedImage();
    }

    public byte[] getBytes(RenderedImage renderedImage, String contentType) throws IOException {
        UnsyncByteArrayOutputStream baos = new UnsyncByteArrayOutputStream();
        this.write(renderedImage, contentType, (OutputStream)baos);
        return baos.toByteArray();
    }

    public ImageBag read(byte[] bytes) {
        RenderedImage renderedImage = null;
        String type = "na";
        Enumeration enu = ImageCodec.getCodecs();
        while (enu.hasMoreElements()) {
            ImageCodec codec = (ImageCodec)enu.nextElement();
            if (!codec.isFormatRecognized(bytes)) continue;
            type = codec.getFormatName();
            ImageDecoder decoder = ImageCodec.createImageDecoder((String)type, (InputStream)new UnsyncByteArrayInputStream(bytes), null);
            try {
                renderedImage = decoder.decodeAsRenderedImage();
            }
            catch (IOException ioe) {
                if (!_log.isDebugEnabled()) break;
                _log.debug((Object)(String.valueOf(type) + ": " + ioe.getMessage()));
            }
            break;
        }
        if (type.equals("jpeg")) {
            type = "jpg";
        }
        return new ImageBag(renderedImage, type);
    }

    public ImageBag read(File file) throws IOException {
        return this.read(_fileUtil.getBytes(file));
    }

    public RenderedImage scale(RenderedImage renderedImage, int width) {
        if (width <= 0) {
            return renderedImage;
        }
        int imageHeight = renderedImage.getHeight();
        int imageWidth = renderedImage.getWidth();
        double factor = (double)width / (double)imageWidth;
        int scaledHeight = (int)(factor * (double)imageHeight);
        int scaledWidth = width;
        BufferedImage bufferedImage = this.getBufferedImage(renderedImage);
        int type = bufferedImage.getType();
        if (type == 0) {
            type = 2;
        }
        BufferedImage scaledBufferedImage = new BufferedImage(scaledWidth, scaledHeight, type);
        Graphics graphics = scaledBufferedImage.getGraphics();
        Image scaledImage = bufferedImage.getScaledInstance(scaledWidth, scaledHeight, 4);
        graphics.drawImage(scaledImage, 0, 0, null);
        return scaledBufferedImage;
    }

    public RenderedImage scale(RenderedImage renderedImage, int maxHeight, int maxWidth) {
        int imageHeight = renderedImage.getHeight();
        int imageWidth = renderedImage.getWidth();
        if (maxHeight == 0) {
            maxHeight = imageHeight;
        }
        if (maxWidth == 0) {
            maxWidth = imageWidth;
        }
        if (imageHeight <= maxHeight && imageWidth <= maxWidth) {
            return renderedImage;
        }
        double factor = Math.min((double)maxHeight / (double)imageHeight, (double)maxWidth / (double)imageWidth);
        int scaledHeight = Math.max(1, (int)(factor * (double)imageHeight));
        int scaledWidth = Math.max(1, (int)(factor * (double)imageWidth));
        BufferedImage bufferedImage = this.getBufferedImage(renderedImage);
        int type = bufferedImage.getType();
        if (type == 0) {
            type = 2;
        }
        BufferedImage scaledBufferedImage = null;
        if (type == 12 || type == 13) {
            IndexColorModel indexColorModel = (IndexColorModel)bufferedImage.getColorModel();
            BufferedImage tempBufferedImage = new BufferedImage(1, 1, type, indexColorModel);
            int bits = indexColorModel.getPixelSize();
            int size = indexColorModel.getMapSize();
            byte[] reds = new byte[size];
            indexColorModel.getReds(reds);
            byte[] greens = new byte[size];
            indexColorModel.getGreens(greens);
            byte[] blues = new byte[size];
            indexColorModel.getBlues(blues);
            WritableRaster writableRaster = tempBufferedImage.getRaster();
            int pixel = writableRaster.getSample(0, 0, 0);
            IndexColorModel scaledIndexColorModel = new IndexColorModel(bits, size, reds, greens, blues, pixel);
            scaledBufferedImage = new BufferedImage(scaledWidth, scaledHeight, type, scaledIndexColorModel);
        } else {
            scaledBufferedImage = new BufferedImage(scaledWidth, scaledHeight, type);
        }
        Graphics graphics = scaledBufferedImage.getGraphics();
        Image scaledImage = bufferedImage.getScaledInstance(scaledWidth, scaledHeight, 4);
        graphics.drawImage(scaledImage, 0, 0, null);
        return scaledBufferedImage;
    }

    public void write(RenderedImage renderedImage, String contentType, OutputStream os) throws IOException {
        if (contentType.contains("bmp")) {
            ImageEncoder imageEncoder = ImageCodec.createImageEncoder((String)"bmp", (OutputStream)os, null);
            imageEncoder.encode(renderedImage);
        } else if (contentType.contains("gif")) {
            this.encodeGIF(renderedImage, os);
        } else if (contentType.contains("jpg") || contentType.contains("jpeg")) {
            ImageIO.write(renderedImage, "jpeg", os);
        } else if (contentType.contains("png")) {
            ImageIO.write(renderedImage, "png", os);
        } else if (contentType.contains("tiff") || contentType.contains("tif")) {
            ImageEncoder imageEncoder = ImageCodec.createImageEncoder((String)"tiff", (OutputStream)os, null);
            imageEncoder.encode(renderedImage);
        }
    }

    private byte[] _toMultiByte(int intValue) {
        int numBits = 32;
        int mask = Integer.MIN_VALUE;
        while (mask != 0 && (intValue & mask) == 0) {
            --numBits;
            mask >>>= 1;
        }
        int numBitsLeft = numBits;
        byte[] multiBytes = new byte[(numBitsLeft + 6) / 7];
        int maxIndex = multiBytes.length - 1;
        int b2 = 0;
        while (b2 <= maxIndex) {
            multiBytes[b2] = (byte)(intValue >>> (maxIndex - b2) * 7 & 0x7F);
            if (b2 != maxIndex) {
                int n = b2;
                multiBytes[n] = (byte)(multiBytes[n] | 0xFFFFFF80);
            }
            ++b2;
        }
        return multiBytes;
    }
}

