/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.increment;

import com.liferay.portal.increment.BufferedIncreasableEntry;
import com.liferay.portal.kernel.cache.key.CacheKeyGenerator;
import com.liferay.portal.kernel.cache.key.CacheKeyGeneratorUtil;
import com.liferay.portal.kernel.concurrent.BatchablePipe;
import com.liferay.portal.kernel.increment.BufferedIncrement;
import com.liferay.portal.kernel.increment.Increment;
import com.liferay.portal.kernel.increment.IncrementFactory;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.spring.aop.AnnotationChainableMethodAdvice;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import org.aopalliance.intercept.MethodInvocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedIncrementAdvice
extends AnnotationChainableMethodAdvice<BufferedIncrement> {
    private static BatchablePipe<String, BufferedIncreasableEntry> _batchablePipe = new BatchablePipe();
    private static BufferedIncrement _nullBufferedIncrement = new BufferedIncrement(){

        public Class<? extends Annotation> annotationType() {
            return BufferedIncrement.class;
        }

        public Class<? extends Increment<?>> incrementClass() {
            return null;
        }

        public boolean parallel() {
            return true;
        }
    };

    @Override
    public Object before(MethodInvocation methodInvocation) throws Throwable {
        Increment increment;
        BufferedIncrement bufferedIncrement = (BufferedIncrement)this.findAnnotation(methodInvocation);
        if (bufferedIncrement == _nullBufferedIncrement) {
            return null;
        }
        Object[] arguments = methodInvocation.getArguments();
        Object value = arguments[arguments.length - 1];
        CacheKeyGenerator cacheKeyGenerator = CacheKeyGeneratorUtil.getCacheKeyGenerator((String)BufferedIncrementAdvice.class.getName());
        cacheKeyGenerator.append(methodInvocation.toString());
        int i2 = 0;
        while (i2 < arguments.length - 1) {
            cacheKeyGenerator.append(StringUtil.toHexString((Object)arguments[i2]));
            ++i2;
        }
        Serializable batchKey = cacheKeyGenerator.finish();
        BufferedIncreasableEntry bufferedIncreasableEntry = new BufferedIncreasableEntry(this.nextMethodInterceptor, methodInvocation, batchKey, increment = IncrementFactory.createIncrement((Class)bufferedIncrement.incrementClass(), (Object)value));
        if (_batchablePipe.put(bufferedIncreasableEntry)) {
            if (bufferedIncrement.parallel()) {
                MessageBusUtil.sendMessage((String)"liferay/buffered_increment_parallel", _batchablePipe);
            } else {
                MessageBusUtil.sendMessage((String)"liferay/buffered_increment_serial", _batchablePipe);
            }
        }
        return this.nullResult;
    }

    @Override
    public BufferedIncrement getNullAnnotation() {
        return _nullBufferedIncrement;
    }
}

