/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jndi.pacl;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.pacl.PACLPolicy;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PACLContext
implements Context {
    private Context _context;
    private PACLPolicy _paclPolicy;

    public PACLContext(Context context, PACLPolicy paclPolicy) {
        this._context = context;
        this._paclPolicy = paclPolicy;
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this._context.addToEnvironment(propName, propVal);
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.checkPACLPolicy(name);
        this._context.bind(name, obj);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.checkPACLPolicy(name);
        this._context.bind(name, obj);
    }

    @Override
    public void close() throws NamingException {
        this._context.close();
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        this.checkPACLPolicy(name);
        return this._context.composeName(name, prefix);
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        this.checkPACLPolicy(name);
        return this._context.composeName(name, prefix);
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        this.checkPACLPolicy(name);
        return this._context.createSubcontext(name);
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        this.checkPACLPolicy(name);
        return this._context.createSubcontext(name);
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.checkPACLPolicy(name);
        this._context.destroySubcontext(name);
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.checkPACLPolicy(name);
        this._context.destroySubcontext(name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Context)) {
            return false;
        }
        Context context = (Context)obj;
        return Validator.equals((Object)this._context, (Object)context);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return this._context.getEnvironment();
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this._context.getNameInNamespace();
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        this.checkPACLPolicy(name);
        return this._context.getNameParser(name);
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        this.checkPACLPolicy(name);
        return this._context.getNameParser(name);
    }

    public int hashCode() {
        return this._context.hashCode();
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        this.checkPACLPolicy(name);
        return this._context.list(name);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        this.checkPACLPolicy(name);
        return this._context.list(name);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        this.checkPACLPolicy(name);
        return this._context.listBindings(name);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        this.checkPACLPolicy(name);
        return this._context.listBindings(name);
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        this.checkPACLPolicy(name);
        return this._context.lookup(name);
    }

    @Override
    public Object lookup(String name) throws NamingException {
        this.checkPACLPolicy(name);
        return this._context.lookup(name);
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        this.checkPACLPolicy(name);
        return this._context.lookupLink(name);
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        this.checkPACLPolicy(name);
        return this._context.lookupLink(name);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.checkPACLPolicy(name);
        this._context.rebind(name, obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.checkPACLPolicy(name);
        this._context.rebind(name, obj);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this._context.removeFromEnvironment(propName);
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        this.checkPACLPolicy(oldName);
        this.checkPACLPolicy(newName);
        this._context.rename(oldName, newName);
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.checkPACLPolicy(oldName);
        this.checkPACLPolicy(newName);
        this._context.rename(oldName, newName);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.checkPACLPolicy(name);
        this._context.unbind(name);
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.checkPACLPolicy(name);
        this._context.unbind(name);
    }

    protected void checkPACLPolicy(Name name) {
        this.checkPACLPolicy(name.toString());
    }

    protected void checkPACLPolicy(String name) {
        if (!this._paclPolicy.hasJNDI(name)) {
            throw new SecurityException("Attempted to use unapproved JNDI " + name);
        }
    }
}

