/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jndi.pacl;

import com.liferay.portal.jndi.pacl.PACLContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.security.lang.PortalSecurityManagerThreadLocal;
import com.liferay.portal.security.pacl.PACLClassUtil;
import com.liferay.portal.security.pacl.PACLPolicy;
import com.liferay.portal.security.pacl.PACLPolicyManager;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PACLInitialContextFactory
implements InitialContextFactory {
    private static Log _log = LogFactoryUtil.getLog((String)PACLInitialContextFactory.class.getName());
    private Hashtable<?, ?> _environment;
    private InitialContextFactoryBuilder _initialContextFactoryBuilder;

    public PACLInitialContextFactory(InitialContextFactoryBuilder initialContextFactoryBuilder, Hashtable<?, ?> environment) {
        this._initialContextFactoryBuilder = initialContextFactoryBuilder;
        if (environment != null) {
            this._environment = new Hashtable(environment);
        }
    }

    @Override
    public Context getInitialContext(Hashtable<?, ?> environment) throws NamingException {
        try {
            return this.doGetInitialContext(environment);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Exception e2) {
            NamingException ne = new NamingException();
            ne.initCause(e2);
            throw ne;
        }
    }

    protected Context doGetInitialContext(Hashtable<?, ?> environment) throws Exception {
        InitialContextFactory initialContextFactory = null;
        if (this._initialContextFactoryBuilder != null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Use " + this._initialContextFactoryBuilder.getClass() + " to instantiate initial context factory"));
            }
            initialContextFactory = this._initialContextFactoryBuilder.createInitialContextFactory(environment);
        } else {
            if (environment == null) {
                environment = this._environment;
            }
            String initialContextFactoryClassName = null;
            if (environment != null) {
                initialContextFactoryClassName = (String)environment.get("java.naming.factory.initial");
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Environment initial context factory " + initialContextFactoryClassName));
                }
            }
            if (initialContextFactoryClassName == null) {
                initialContextFactoryClassName = System.getProperty("java.naming.factory.initial");
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("System initial context factory " + initialContextFactoryClassName));
                }
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Instantiating " + initialContextFactoryClassName));
            }
            initialContextFactory = (InitialContextFactory)InstanceFactory.newInstance((String)initialContextFactoryClassName);
        }
        Context context = initialContextFactory.getInitialContext(environment);
        if (!PACLPolicyManager.isActive() || !PortalSecurityManagerThreadLocal.isEnabled()) {
            return context;
        }
        PACLPolicy paclPolicy = PACLClassUtil.getPACLPolicy(false, _log.isDebugEnabled());
        if (paclPolicy == null || !paclPolicy.isActive()) {
            return context;
        }
        return new PACLContext(context, paclPolicy);
    }
}

