/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.json;

import com.liferay.portal.kernel.json.JSON;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONIncludesManager {
    private static final String[] _EMPTY_LIST = new String[0];
    private static final String _EXCLUDE_ALL = "*";
    private Map<Class<?>, String[]> _excludesMap = new HashMap();
    private Map<Class<?>, String[]> _includesMap = new HashMap();

    public String[] lookupExcludes(Class<?> type) {
        String[] excludes = this._excludesMap.get(type);
        if (excludes != null) {
            return excludes;
        }
        ArrayList<String> list = new ArrayList<String>();
        while (type != null) {
            JSON jsonAnnotation = type.getAnnotation(JSON.class);
            if (jsonAnnotation != null && jsonAnnotation.strict()) {
                list.add(_EXCLUDE_ALL);
                break;
            }
            this._scanFieldsAndMethods(list, type, false);
            type = type.getSuperclass();
        }
        excludes = this._listToArray(list);
        this._excludesMap.put(type, excludes);
        return excludes;
    }

    public String[] lookupIncludes(Class<?> type) {
        String[] includes = this._includesMap.get(type);
        if (includes != null) {
            return includes;
        }
        ArrayList<String> list = new ArrayList<String>();
        while (type != null) {
            this._scanFieldsAndMethods(list, type, true);
            type = type.getSuperclass();
        }
        includes = this._listToArray(list);
        this._includesMap.put(type, includes);
        return includes;
    }

    private String _getPropertyName(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 0) {
            return null;
        }
        String propertyName = null;
        String methodName = method.getName();
        if (methodName.startsWith("get")) {
            propertyName = methodName.substring(3);
        } else if (methodName.startsWith("has")) {
            propertyName = methodName.substring(3);
        } else if (methodName.startsWith("is")) {
            propertyName = methodName.substring(2);
        } else {
            return null;
        }
        if (propertyName.length() > 2 && Character.isUpperCase(propertyName.charAt(1))) {
            return propertyName;
        }
        return String.valueOf(Character.toLowerCase(propertyName.charAt(0))) + propertyName.substring(1);
    }

    private String[] _listToArray(List<String> list) {
        if (list.isEmpty()) {
            return _EMPTY_LIST;
        }
        return list.toArray(new String[list.size()]);
    }

    private void _scanFieldsAndMethods(List<String> list, Class<?> type, boolean include) {
        Method[] methods;
        Field[] fields;
        Field[] fieldArray = fields = type.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            Field field = fieldArray[n2];
            JSON jsonAnnotation = field.getAnnotation(JSON.class);
            if (jsonAnnotation != null && jsonAnnotation.include() == include && !list.contains(name = field.getName())) {
                list.add(name);
            }
            ++n2;
        }
        Method[] methodArray = methods = type.getDeclaredMethods();
        int n3 = methods.length;
        n = 0;
        while (n < n3) {
            String name;
            Method method = methodArray[n];
            JSON jsonAnnotation = method.getAnnotation(JSON.class);
            if (jsonAnnotation != null && jsonAnnotation.include() == include && (name = this._getPropertyName(method)) != null && !list.contains(name)) {
                list.add(name);
            }
            ++n;
        }
    }
}

