/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsonwebservice;

import com.liferay.portal.jsonwebservice.JSONRPCRequest;
import com.liferay.portal.jsonwebservice.JSONRPCResponse;
import com.liferay.portal.jsonwebservice.JSONWebServiceActionConfig;
import com.liferay.portal.jsonwebservice.JSONWebServiceActionParameters;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceAction;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionMapping;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.CamelCaseUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MethodParameter;
import com.liferay.portal.service.ServiceContext;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jodd.bean.BeanUtil;
import jodd.typeconverter.TypeConverterManager;
import jodd.util.KeyValue;
import jodd.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONWebServiceActionImpl
implements JSONWebServiceAction {
    private static Log _log = LogFactoryUtil.getLog(JSONWebServiceActionImpl.class);
    private JSONWebServiceActionConfig _jsonWebServiceActionConfig;
    private JSONWebServiceActionParameters _jsonWebServiceActionParameters;

    public JSONWebServiceActionImpl(JSONWebServiceActionConfig jsonWebServiceActionConfig, JSONWebServiceActionParameters jsonWebServiceActionParameters) {
        this._jsonWebServiceActionConfig = jsonWebServiceActionConfig;
        this._jsonWebServiceActionParameters = jsonWebServiceActionParameters;
    }

    public JSONWebServiceActionMapping getJSONWebServiceActionMapping() {
        return this._jsonWebServiceActionConfig;
    }

    public Object invoke() throws Exception {
        JSONRPCRequest jsonRPCRequest = this._jsonWebServiceActionParameters.getJSONRPCRequest();
        if (jsonRPCRequest == null) {
            return this._invokeActionMethod();
        }
        Object result = null;
        Exception exception = null;
        try {
            result = this._invokeActionMethod();
        }
        catch (Exception e2) {
            exception = e2;
            _log.error((Object)e2, (Throwable)e2);
        }
        return new JSONRPCResponse(jsonRPCRequest, result, exception);
    }

    private Object _createDefaultParameterValue(String parameterName, Class<?> parameterType) throws Exception {
        if (parameterName.equals("serviceContext") && parameterType.equals(ServiceContext.class)) {
            return new ServiceContext();
        }
        String className = parameterType.getName();
        if (className.contains("com.liferay") && className.contains("Util")) {
            throw new IllegalArgumentException("Not instantiating " + className);
        }
        return parameterType.newInstance();
    }

    private List<?> _generifyList(List<?> list, Class<?>[] types) {
        if (types == null) {
            return list;
        }
        if (types.length != 1) {
            return list;
        }
        ArrayList newList = new ArrayList(list.size());
        for (Object entry : list) {
            if (entry != null) {
                entry = TypeConverterManager.convertType(entry, types[0]);
            }
            newList.add(entry);
        }
        return newList;
    }

    private Map<?, ?> _generifyMap(Map<?, ?> map, Class<?>[] types) {
        if (types == null) {
            return map;
        }
        if (types.length != 2) {
            return map;
        }
        HashMap newMap = new HashMap(map.size());
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = TypeConverterManager.convertType(entry.getKey(), types[0]);
            Object value = entry.getValue();
            if (value != null) {
                value = TypeConverterManager.convertType(value, types[1]);
            }
            newMap.put(key, value);
        }
        return newMap;
    }

    private void _injectInnerParametersIntoValue(String parameterName, Object parameterValue) {
        if (parameterValue == null) {
            return;
        }
        List<KeyValue<String, Object>> innerParameters = this._jsonWebServiceActionParameters.getInnerParameters(parameterName);
        if (innerParameters == null) {
            return;
        }
        for (KeyValue<String, Object> innerParameter : innerParameters) {
            try {
                BeanUtil.setProperty((Object)parameterValue, (String)((String)innerParameter.getKey()), (Object)innerParameter.getValue());
            }
            catch (Exception e2) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("Unable to set inner parameter " + parameterName + "." + (String)innerParameter.getKey()), (Throwable)e2);
            }
        }
    }

    private Object _invokeActionMethod() throws Exception {
        Method actionMethod = this._jsonWebServiceActionConfig.getActionMethod();
        Class<?> actionClass = this._jsonWebServiceActionConfig.getActionClass();
        Object[] parameters = this._prepareParameters(actionClass);
        return actionMethod.invoke(actionClass, parameters);
    }

    private Object[] _prepareParameters(Class<?> actionClass) throws Exception {
        MethodParameter[] methodParameters = this._jsonWebServiceActionConfig.getMethodParameters();
        Object[] parameters = new Object[methodParameters.length];
        int i2 = 0;
        while (i2 < methodParameters.length) {
            String parameterName = methodParameters[i2].getName();
            parameterName = CamelCaseUtil.normalizeCamelCase((String)parameterName);
            Object value = this._jsonWebServiceActionParameters.getParameter(parameterName);
            Object parameterValue = null;
            if (value != null) {
                Class<?> parameterType = methodParameters[i2].getType();
                if (value.equals(Void.TYPE)) {
                    String parameterTypeName = this._jsonWebServiceActionParameters.getParameterTypeName(parameterName);
                    if (parameterTypeName != null) {
                        ClassLoader classLoader = actionClass.getClassLoader();
                        parameterType = classLoader.loadClass(parameterTypeName);
                    }
                    if (!ReflectUtil.isSubclass((Class)parameterType, (Class)methodParameters[i2].getType())) {
                        throw new IllegalArgumentException("Unmatched argument type " + parameterType.getName() + " for method argument " + i2);
                    }
                    parameterValue = this._createDefaultParameterValue(parameterName, parameterType);
                } else if (parameterType.equals(Calendar.class)) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setLenient(false);
                    calendar.setTimeInMillis(GetterUtil.getLong((String)value.toString()));
                    parameterValue = calendar;
                } else if (parameterType.equals(List.class)) {
                    List<?> list = (List<?>)JSONFactoryUtil.looseDeserializeSafe((String)value.toString(), ArrayList.class);
                    list = this._generifyList(list, methodParameters[i2].getGenericTypes());
                    parameterValue = list;
                } else if (parameterType.equals(Locale.class)) {
                    parameterValue = LocaleUtil.fromLanguageId((String)value.toString());
                } else if (parameterType.equals(Map.class)) {
                    Map<?, ?> map = (Map<?, ?>)JSONFactoryUtil.looseDeserializeSafe((String)value.toString(), HashMap.class);
                    map = this._generifyMap(map, methodParameters[i2].getGenericTypes());
                    parameterValue = map;
                } else {
                    parameterValue = TypeConverterManager.convertType((Object)value, parameterType);
                }
            }
            this._injectInnerParametersIntoValue(parameterName, parameterValue);
            parameters[i2] = parameterValue;
            ++i2;
        }
        return parameters;
    }
}

