/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsonwebservice;

import com.liferay.portal.jsonwebservice.JSONWebServiceClassVisitor;
import com.liferay.portal.jsonwebservice.JSONWebServiceMappingResolver;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.jsonwebservice.JSONWebService;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionsManagerUtil;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceMode;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.pacl.PACLClassLoaderUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jodd.io.findfile.ClassFinder;
import jodd.io.findfile.RegExpFindFile;
import jodd.util.ClassLoaderUtil;
import org.apache.commons.lang.time.StopWatch;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONWebServiceConfigurator
extends ClassFinder {
    private static Log _log = LogFactoryUtil.getLog(JSONWebServiceConfigurator.class);
    private ClassLoader _classLoader;
    private Set<String> _invalidHttpMethods = SetUtil.fromArray((Object[])PropsValues.JSONWS_WEB_SERVICE_INVALID_HTTP_METHODS);
    private byte[] _jsonWebServiceAnnotationBytes = this.getTypeSignatureBytes(JSONWebService.class);
    private JSONWebServiceMappingResolver _jsonWebServiceMappingResolver = new JSONWebServiceMappingResolver();
    private int _registeredActionsCount;
    private String _servletContextPath;
    private Map<Class<?>, Class<?>> _utilClasses = new HashMap();

    public JSONWebServiceConfigurator(String servletContextPath) {
        this.setIncludedJars(new String[]{"*_wl_cls_gen.jar", "*-hook-service*.jar", "*-portlet-service*.jar", "*-web-service*.jar", "*portal-impl.jar", "*portal-service.jar"});
        this._servletContextPath = servletContextPath;
    }

    public void clean() {
        int count = JSONWebServiceActionsManagerUtil.unregisterJSONWebServiceActions((String)this._servletContextPath);
        this._registeredActionsCount -= count;
        if (_log.isDebugEnabled() && count != 0) {
            _log.debug((Object)("Removed " + count + " existing JSON Web Service actions that belonged to " + this._servletContextPath));
        }
    }

    public void configure(ClassLoader classLoader) throws PortalException, SystemException {
        File[] classPathFiles = null;
        if (classLoader != null) {
            URL servicePropertiesURL = classLoader.getResource("service.properties");
            String servicePropertiesPath = null;
            try {
                servicePropertiesPath = URLDecoder.decode(servicePropertiesURL.getPath(), "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                throw new SystemException((Throwable)uee);
            }
            File classPathFile = null;
            File libDir = null;
            int pos = servicePropertiesPath.indexOf("_wl_cls_gen.jar!");
            if (pos != -1) {
                String wlClsGenJarPath = servicePropertiesPath.substring(0, pos + 15);
                classPathFile = new File(wlClsGenJarPath);
                libDir = new File(classPathFile.getParent());
            } else {
                File servicePropertiesFile = new File(servicePropertiesPath);
                classPathFile = servicePropertiesFile.getParentFile();
                libDir = new File(classPathFile.getParent(), "lib");
            }
            classPathFiles = new File[2];
            classPathFiles[0] = classPathFile;
            RegExpFindFile findFile = new RegExpFindFile(".*-(hook|portlet|web)-service.*\\.jar");
            findFile.searchPath(libDir);
            classPathFiles[1] = findFile.nextFile();
            if (classPathFiles[1] == null) {
                File classesDir;
                classPathFiles[1] = classesDir = new File(libDir.getParent(), "classes");
            }
        } else {
            classLoader = PACLClassLoaderUtil.getContextClassLoader();
            File portalImplJarFile = new File(PortalUtil.getPortalLibDir(), "portal-impl.jar");
            File portalServiceJarFile = new File(PortalUtil.getGlobalLibDir(), "portal-service.jar");
            classPathFiles = portalImplJarFile.exists() && portalServiceJarFile.exists() ? new File[]{portalImplJarFile, portalServiceJarFile} : ClassLoaderUtil.getDefaultClasspath((ClassLoader)classLoader);
        }
        this._classLoader = classLoader;
        this._configure(classPathFiles);
    }

    protected void onEntry(ClassFinder.EntryData entryData) throws Exception {
        String className = entryData.getName();
        if (className.endsWith("Service") || className.endsWith("ServiceImpl")) {
            InputStream inputStream = entryData.openInputStream();
            if (!this.isTypeSignatureInUse(inputStream, this._jsonWebServiceAnnotationBytes)) {
                return;
            }
            if (!entryData.isArchive()) {
                StreamUtil.cleanUp((InputStream)inputStream);
                ClassReader classReader = new ClassReader(entryData.openInputStream());
                JSONWebServiceClassVisitor jsonWebServiceClassVisitor = new JSONWebServiceClassVisitor();
                try {
                    classReader.accept((ClassVisitor)jsonWebServiceClassVisitor, 0);
                }
                catch (Exception exception) {
                    return;
                }
                if (!className.equals(jsonWebServiceClassVisitor.getClassName())) {
                    return;
                }
            }
            this._onJSONWebServiceClass(className);
        }
    }

    private void _configure(File ... classPathFiles) throws PortalException {
        StopWatch stopWatch = null;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Configure JSON web service actions");
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        try {
            this.scanPaths(classPathFiles);
        }
        catch (Exception e2) {
            throw new PortalException(e2.getMessage(), (Throwable)e2);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Configured " + this._registeredActionsCount + " actions in " + stopWatch.getTime() + " ms"));
        }
    }

    private boolean _hasAnnotatedServiceImpl(String className) {
        StringBundler implClassName = new StringBundler(4);
        int pos = className.lastIndexOf(46);
        implClassName.append(className.substring(0, pos));
        implClassName.append(".impl");
        implClassName.append(className.substring(pos));
        implClassName.append("Impl");
        Class<?> implClass = null;
        try {
            implClass = this._classLoader.loadClass(implClassName.toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return implClass.getAnnotation(JSONWebService.class) != null;
    }

    private boolean _isJSONWebServiceClass(Class<?> clazz) {
        return !clazz.isAnonymousClass() && !clazz.isArray() && !clazz.isEnum() && !clazz.isLocalClass() && !clazz.isPrimitive() && !(clazz.isMemberClass() ^ Modifier.isStatic(clazz.getModifiers()));
    }

    private Class<?> _loadUtilClass(Class<?> implementationClass) throws ClassNotFoundException {
        Class<?> utilClass = this._utilClasses.get(implementationClass);
        if (utilClass != null) {
            return utilClass;
        }
        String utilClassName = implementationClass.getName();
        if (utilClassName.endsWith("Impl")) {
            utilClassName = utilClassName.substring(0, utilClassName.length() - 4);
        }
        utilClassName = String.valueOf(utilClassName) + "Util";
        utilClassName = StringUtil.replace((String)utilClassName, (String)".impl.", (String)".");
        utilClass = this._classLoader.loadClass(utilClassName);
        this._utilClasses.put(implementationClass, utilClass);
        return utilClass;
    }

    private void _onJSONWebServiceClass(String className) throws Exception {
        Method[] methods;
        Class<?> actionClass = this._classLoader.loadClass(className);
        if (!this._isJSONWebServiceClass(actionClass)) {
            return;
        }
        if (actionClass.isInterface() && this._hasAnnotatedServiceImpl(className)) {
            return;
        }
        JSONWebService classAnnotation = actionClass.getAnnotation(JSONWebService.class);
        JSONWebServiceMode classAnnotationMode = JSONWebServiceMode.MANUAL;
        if (classAnnotation != null) {
            classAnnotationMode = classAnnotation.mode();
        }
        Method[] methodArray = methods = actionClass.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            Class<?> methodDeclaringClass = method.getDeclaringClass();
            if (methodDeclaringClass.equals(actionClass)) {
                JSONWebServiceMode methodAnnotationMode;
                boolean registerMethod = false;
                JSONWebService methodAnnotation = method.getAnnotation(JSONWebService.class);
                if (classAnnotationMode.equals((Object)JSONWebServiceMode.AUTO)) {
                    registerMethod = true;
                    if (methodAnnotation != null && (methodAnnotationMode = methodAnnotation.mode()).equals((Object)JSONWebServiceMode.IGNORE)) {
                        registerMethod = false;
                    }
                } else if (methodAnnotation != null && !(methodAnnotationMode = methodAnnotation.mode()).equals((Object)JSONWebServiceMode.IGNORE)) {
                    registerMethod = true;
                }
                if (registerMethod) {
                    this._registerJSONWebServiceAction(actionClass, method);
                }
            }
            ++n2;
        }
    }

    private void _registerJSONWebServiceAction(Class<?> implementationClass, Method method) throws Exception {
        String path = this._jsonWebServiceMappingResolver.resolvePath(implementationClass, method);
        String httpMethod = this._jsonWebServiceMappingResolver.resolveHttpMethod(method);
        if (this._invalidHttpMethods.contains(httpMethod)) {
            return;
        }
        Class<?> utilClass = this._loadUtilClass(implementationClass);
        try {
            method = utilClass.getMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return;
        }
        JSONWebServiceActionsManagerUtil.registerJSONWebServiceAction((String)this._servletContextPath, method.getDeclaringClass(), (Method)method, (String)path, (String)httpMethod);
        ++this._registeredActionsCount;
    }
}

