/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsonwebservice;

import com.liferay.portal.kernel.jsonwebservice.JSONWebService;
import com.liferay.portal.kernel.util.CamelCaseUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONWebServiceMappingResolver {
    private static final String[] _GET_PREFIXES = new String[]{"get", "has", "is"};

    public String resolveHttpMethod(Method method) {
        JSONWebService jsonWebServiceAnnotation = method.getAnnotation(JSONWebService.class);
        String httpMethod = null;
        if (jsonWebServiceAnnotation != null) {
            httpMethod = jsonWebServiceAnnotation.method().trim();
        }
        if (httpMethod != null && httpMethod.length() != 0) {
            return httpMethod;
        }
        String methodName = method.getName();
        String methodNamePrefix = this._cutPrefix(methodName);
        return this._prefixToHttpMethod(methodNamePrefix);
    }

    public String resolvePath(Class<?> clazz, Method method) {
        JSONWebService jsonWebServiceAnnotation = method.getAnnotation(JSONWebService.class);
        String path = null;
        if (jsonWebServiceAnnotation != null) {
            path = jsonWebServiceAnnotation.value().trim();
        }
        if (path == null || path.length() == 0) {
            path = CamelCaseUtil.fromCamelCase((String)method.getName());
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
            String pathFromClass = null;
            jsonWebServiceAnnotation = clazz.getAnnotation(JSONWebService.class);
            if (jsonWebServiceAnnotation != null) {
                pathFromClass = jsonWebServiceAnnotation.value().trim();
            }
            if (pathFromClass == null || pathFromClass.length() == 0) {
                pathFromClass = this._classNameToPath(clazz);
            }
            if (!pathFromClass.startsWith("/")) {
                pathFromClass = "/" + pathFromClass;
            }
            path = String.valueOf(pathFromClass) + path;
        }
        return path;
    }

    private String _classNameToPath(Class<?> clazz) {
        String className = clazz.getSimpleName();
        className = StringUtil.replace((String)className, (String)"Impl", (String)"");
        className = StringUtil.replace((String)className, (String)"Service", (String)"");
        return className.toLowerCase();
    }

    private String _cutPrefix(String methodName) {
        int i2 = 0;
        while (i2 < methodName.length()) {
            if (Character.isUpperCase(methodName.charAt(i2))) break;
            ++i2;
        }
        return methodName.substring(0, i2);
    }

    private String _prefixToHttpMethod(String prefix) {
        String[] stringArray = _GET_PREFIXES;
        int n = _GET_PREFIXES.length;
        int n2 = 0;
        while (n2 < n) {
            String postPrefix = stringArray[n2];
            if (prefix.equals(postPrefix)) {
                return "GET";
            }
            ++n2;
        }
        return "POST";
    }
}

